package com.zehong.system.service.impl;

import java.util.List;
import com.zehong.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TDevInspectMapper;
import com.zehong.system.domain.TDevInspect;
import com.zehong.system.service.ITDevInspectService;

/**
 * 设备检验记录（生命全周期）Service业务层处理
 * 
 * @author zehong
 * @date 2023-12-15
 */
@Service
public class TDevInspectServiceImpl implements ITDevInspectService 
{
    @Autowired
    private TDevInspectMapper tDevInspectMapper;

    /**
     * 查询设备检验记录（生命全周期）
     * 
     * @param id 设备检验记录（生命全周期）ID
     * @return 设备检验记录（生命全周期）
     */
    @Override
    public TDevInspect selectTDevInspectById(Long id)
    {
        return tDevInspectMapper.selectTDevInspectById(id);
    }

    /**
     * 查询设备检验记录（生命全周期）列表
     * 
     * @param tDevInspect 设备检验记录（生命全周期）
     * @return 设备检验记录（生命全周期）
     */
    @Override
    public List<TDevInspect> selectTDevInspectList(TDevInspect tDevInspect)
    {
        return tDevInspectMapper.selectTDevInspectList(tDevInspect);
    }

    /**
     * 新增设备检验记录（生命全周期）
     * 
     * @param tDevInspect 设备检验记录（生命全周期）
     * @return 结果
     */
    @Override
    public int insertTDevInspect(TDevInspect tDevInspect)
    {
        tDevInspect.setCreateTime(DateUtils.getNowDate());
        return tDevInspectMapper.insertTDevInspect(tDevInspect);
    }

    /**
     * 修改设备检验记录（生命全周期）
     * 
     * @param tDevInspect 设备检验记录（生命全周期）
     * @return 结果
     */
    @Override
    public int updateTDevInspect(TDevInspect tDevInspect)
    {
        return tDevInspectMapper.updateTDevInspect(tDevInspect);
    }

    /**
     * 批量删除设备检验记录（生命全周期）
     * 
     * @param ids 需要删除的设备检验记录（生命全周期）ID
     * @return 结果
     */
    @Override
    public int deleteTDevInspectByIds(Long[] ids)
    {
        return tDevInspectMapper.deleteTDevInspectByIds(ids);
    }

    /**
     * 删除设备检验记录（生命全周期）信息
     * 
     * @param id 设备检验记录（生命全周期）ID
     * @return 结果
     */
    @Override
    public int deleteTDevInspectById(Long id)
    {
        return tDevInspectMapper.deleteTDevInspectById(id);
    }
}
