package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.TPipePoint;

/**
 * 管线打卡点Service接口
 * 
 * @author zehong
 * @date 2023-11-15
 */
public interface ITPipePointService 
{
    /**
     * 查询管线打卡点
     * 
     * @param id 管线打卡点ID
     * @return 管线打卡点
     */
    public TPipePoint selectTPipePointById(Long id);

    /**
     * 查询管线打卡点列表
     * 
     * @param tPipePoint 管线打卡点
     * @return 管线打卡点集合
     */
    public List<TPipePoint> selectTPipePointList(TPipePoint tPipePoint);

    /**
     * 新增管线打卡点
     * 
     * @param tPipePoint 管线打卡点
     * @return 结果
     */
    public int insertTPipePoint(TPipePoint tPipePoint);

    /**
     * 修改管线打卡点
     * 
     * @param tPipePoint 管线打卡点
     * @return 结果
     */
    public int updateTPipePoint(TPipePoint tPipePoint);

    /**
     * 批量删除管线打卡点
     * 
     * @param ids 需要删除的管线打卡点ID
     * @return 结果
     */
    public int deleteTPipePointByIds(Long[] ids);

    /**
     * 删除管线打卡点信息
     * 
     * @param id 管线打卡点ID
     * @return 结果
     */
    public int deleteTPipePointById(Long id);

    List<TPipePoint> selectPointDetail(String pipeType);
}
