package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.TEmergencyDisposeStep;

/**
 * 应急处置步骤Service接口
 * 
 * @author zehong
 * @date 2024-09-07
 */
public interface ITEmergencyDisposeStepService 
{
    /**
     * 查询应急处置步骤
     * 
     * @param stepId 应急处置步骤ID
     * @return 应急处置步骤
     */
    public TEmergencyDisposeStep selectTEmergencyDisposeStepById(Long stepId);

    /**
     * 查询应急处置步骤列表
     * 
     * @param tEmergencyDisposeStep 应急处置步骤
     * @return 应急处置步骤集合
     */
    public List<TEmergencyDisposeStep> selectTEmergencyDisposeStepList(TEmergencyDisposeStep tEmergencyDisposeStep);

    /**
     * 新增应急处置步骤
     * 
     * @param tEmergencyDisposeStep 应急处置步骤
     * @return 结果
     */
    public int insertTEmergencyDisposeStep(TEmergencyDisposeStep tEmergencyDisposeStep);

    /**
     * 修改应急处置步骤
     * 
     * @param tEmergencyDisposeStep 应急处置步骤
     * @return 结果
     */
    public int updateTEmergencyDisposeStep(TEmergencyDisposeStep tEmergencyDisposeStep);

    /**
     * 批量删除应急处置步骤
     * 
     * @param stepIds 需要删除的应急处置步骤ID
     * @return 结果
     */
    public int deleteTEmergencyDisposeStepByIds(Long[] stepIds);

    /**
     * 删除应急处置步骤信息
     * 
     * @param stepId 应急处置步骤ID
     * @return 结果
     */
    public int deleteTEmergencyDisposeStepById(Long stepId);
}
