package com.zehong.system.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 报警器报警记录对象 t_gas_alarm
 * 
 * @author zehong
 * @date 2024-09-10
 */
public class TGasAlarm extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** $column.columnComment */
    private Long id;

    /** 设备编号 */
    @Excel(name = "设备编号")
    private String number;

    /** 设备状态 */
    @Excel(name = "设备状态")
    private Integer reportStatus;

    /** 安装位置 */
    @Excel(name = "安装位置")
    private String position;

    /** $column.columnComment */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "报警开始时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date starttime;

    /** $column.columnComment */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "报警结束时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date endtime;

    /** $column.columnComment */
    @Excel(name = "上报数值")
    private String nd;

    /** $column.columnComment */
    private String paramsData;

    /** 报警状态 */
    @Excel(name = "报警状态",dictType = "t_gas_alarm_status\n")
    private Integer status;

    /** 类型 */
    @Excel(name = "类型",dictType = "t_gas_alarm_type")
    private Integer type;

    /** 报警原因 */
    @Excel(name = "报警原因",dictType = "t_gas_alarm_reason")
    private Integer reason;

    /** $column.columnComment */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createdAt;

    /** $column.columnComment */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updatedAt;

    private BigDecimal longitude;

    private BigDecimal latitude;

    public void setId(Long id) 
    {
        this.id = id;
    }

    public Long getId() 
    {
        return id;
    }
    public void setNumber(String number) 
    {
        this.number = number;
    }

    public String getNumber() 
    {
        return number;
    }
    public void setReportStatus(Integer reportStatus) 
    {
        this.reportStatus = reportStatus;
    }

    public Integer  getReportStatus()
    {
        return reportStatus;
    }

    public String getPosition() {
        return position;
    }

    public void setPosition(String position) {
        this.position = position;
    }

    public void setStarttime(Date starttime)
    {
        this.starttime = starttime;
    }

    public Date getStarttime() 
    {
        return starttime;
    }
    public void setEndtime(Date endtime) 
    {
        this.endtime = endtime;
    }

    public Date getEndtime() 
    {
        return endtime;
    }
    public void setNd(String nd) 
    {
        this.nd = nd;
    }

    public String getNd() 
    {
        return nd;
    }

    public String getParamsData() {
        return paramsData;
    }

    public void setParamsData(String paramsData) {
        this.paramsData = paramsData;
    }

    public void setStatus(Integer status)
    {
        this.status = status;
    }

    public Integer getStatus() 
    {
        return status;
    }
    public void setType(Integer type) 
    {
        this.type = type;
    }

    public Integer getType() 
    {
        return type;
    }
    public void setReason(Integer reason) 
    {
        this.reason = reason;
    }

    public Integer getReason() 
    {
        return reason;
    }
    public void setCreatedAt(Date createdAt) 
    {
        this.createdAt = createdAt;
    }

    public Date getCreatedAt() 
    {
        return createdAt;
    }
    public void setUpdatedAt(Date updatedAt) 
    {
        this.updatedAt = updatedAt;
    }

    public Date getUpdatedAt() 
    {
        return updatedAt;
    }

    public BigDecimal getLongitude() {
        return longitude;
    }

    public void setLongitude(BigDecimal longitude) {
        this.longitude = longitude;
    }

    public BigDecimal getLatitude() {
        return latitude;
    }

    public void setLatitude(BigDecimal latitude) {
        this.latitude = latitude;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("number", getNumber())
            .append("reportStatus", getReportStatus())
            .append("starttime", getStarttime())
            .append("endtime", getEndtime())
            .append("nd", getNd())
            .append("params", getParams())
            .append("status", getStatus())
            .append("type", getType())
            .append("reason", getReason())
            .append("remark", getRemark())
            .append("createdAt", getCreatedAt())
            .append("updatedAt", getUpdatedAt())
            .toString();
    }
}
