package com.zehong.quartz.task;

import com.zehong.system.service.ITTaskInspectExportService;
import cn.hutool.core.date.DateUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import java.util.Date;

@Component("InspectExportTask")
public class InspectExportTask {

    @Autowired
    private ITTaskInspectExportService taskInspectExportService;

    /**
     * 定时导出昨天安检单
     */
    public void exportDaily(){
        Date yesterday = DateUtil.yesterday();
        Date beginOfDay = DateUtil.beginOfDay(yesterday);
        Date endOfDay = DateUtil.endOfDay(yesterday);
        taskInspectExportService.batchExportInspect(DateUtil.format(beginOfDay, "yyyy-MM-dd HH:mm:ss"),DateUtil.format(endOfDay, "yyyy-MM-dd HH:mm:ss"),null);
    }

    /**
     * 手动导出
     * @param beginTime
     * @param endTime
     */
    public void exportDaily(String beginTime,String endTime,String taskId){
        taskInspectExportService.batchExportInspect(beginTime,endTime,taskId);
    }
}
