package com.zehong.web.controller.gasdata;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TGasData;
import com.zehong.system.service.ITGasDataService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 监测设备数据Controller
 * 
 * @author zehong
 * @date 2024-03-02
 */
@RestController
@RequestMapping("/gas/data")
public class TGasDataController extends BaseController
{
    @Autowired
    private ITGasDataService tGasDataService;

    /**
     * 查询监测设备数据列表
     */
    //@PreAuthorize("@ss.hasPermi('gas:data:list')")
    @GetMapping("/list")
    public TableDataInfo list(TGasData tGasData)
    {
        startPage();
        List<TGasData> list = tGasDataService.selectTGasDataList(tGasData);
        return getDataTable(list);
    }

    /**
     * 导出监测设备数据列表
     */
    //@PreAuthorize("@ss.hasPermi('gas:data:export')")
    @Log(title = "监测设备数据", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TGasData tGasData)
    {
        List<TGasData> list = tGasDataService.selectTGasDataList(tGasData);
        ExcelUtil<TGasData> util = new ExcelUtil<TGasData>(TGasData.class);
        return util.exportExcel(list, "监测设备数据数据");
    }

    /**
     * 获取监测设备数据详细信息
     */
    //@PreAuthorize("@ss.hasPermi('gas:data:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(tGasDataService.selectTGasDataById(id));
    }

    /**
     * 新增监测设备数据
     */
    //@PreAuthorize("@ss.hasPermi('gas:data:add')")
    @Log(title = "监测设备数据", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TGasData tGasData)
    {
        return toAjax(tGasDataService.insertTGasData(tGasData));
    }

    /**
     * 修改监测设备数据
     */
    //@PreAuthorize("@ss.hasPermi('gas:data:edit')")
    @Log(title = "监测设备数据", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TGasData tGasData)
    {
        return toAjax(tGasDataService.updateTGasData(tGasData));
    }

    /**
     * 删除监测设备数据
     */
    //@PreAuthorize("@ss.hasPermi('gas:data:remove')")
    @Log(title = "监测设备数据", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(tGasDataService.deleteTGasDataByIds(ids));
    }
}
