package com.zehong.web.controller.emergency;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TEmergencyResponse;
import com.zehong.system.service.ITEmergencyResponseService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 应急响应Controller
 * 
 * @author zehong
 * @date 2024-09-06
 */
@RestController
@RequestMapping("/emergency/response")
public class TEmergencyResponseController extends BaseController
{
    @Autowired
    private ITEmergencyResponseService tEmergencyResponseService;

    /**
     * 查询应急响应列表
     */
   // @PreAuthorize("@ss.hasPermi('emergency:response:list')")
    @GetMapping("/list")
    public TableDataInfo list(TEmergencyResponse tEmergencyResponse)
    {
        startPage();
        List<TEmergencyResponse> list = tEmergencyResponseService.selectTEmergencyResponseList(tEmergencyResponse);
        return getDataTable(list);
    }

    @GetMapping("/emergencyResponseList")
    public AjaxResult emergencyResponseList(TEmergencyResponse tEmergencyResponse)
    {
        List<TEmergencyResponse> list = tEmergencyResponseService.selectTEmergencyResponseList(tEmergencyResponse);
        return AjaxResult.success(list);
    }

    /**
     * 导出应急响应列表
     */
    //@PreAuthorize("@ss.hasPermi('emergency:response:export')")
    @Log(title = "应急响应", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TEmergencyResponse tEmergencyResponse)
    {
        List<TEmergencyResponse> list = tEmergencyResponseService.selectTEmergencyResponseList(tEmergencyResponse);
        ExcelUtil<TEmergencyResponse> util = new ExcelUtil<TEmergencyResponse>(TEmergencyResponse.class);
        return util.exportExcel(list, "应急响应数据");
    }

    /**
     * 获取应急响应详细信息
     */
    //@PreAuthorize("@ss.hasPermi('emergency:response:query')")
    @GetMapping(value = "/{responseId}")
    public AjaxResult getInfo(@PathVariable("responseId") Long responseId)
    {
        return AjaxResult.success(tEmergencyResponseService.selectTEmergencyResponseById(responseId));
    }

    /**
     * 新增应急响应
     */
    //@PreAuthorize("@ss.hasPermi('emergency:response:add')")
    @Log(title = "应急响应", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TEmergencyResponse tEmergencyResponse)
    {
        return toAjax(tEmergencyResponseService.insertTEmergencyResponse(tEmergencyResponse));
    }

    /**
     * 修改应急响应
     */
    //@PreAuthorize("@ss.hasPermi('emergency:response:edit')")
    @Log(title = "应急响应", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TEmergencyResponse tEmergencyResponse)
    {
        return toAjax(tEmergencyResponseService.updateTEmergencyResponse(tEmergencyResponse));
    }

    /**
     * 删除应急响应
     */
    //@PreAuthorize("@ss.hasPermi('emergency:response:remove')")
    @Log(title = "应急响应", businessType = BusinessType.DELETE)
	@DeleteMapping("/{responseIds}")
    public AjaxResult remove(@PathVariable Long[] responseIds)
    {
        return toAjax(tEmergencyResponseService.deleteTEmergencyResponseByIds(responseIds));
    }
}
