package com.zehong.web.controller.emergency;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TEmergencyDisposeStep;
import com.zehong.system.service.ITEmergencyDisposeStepService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 应急处置步骤Controller
 * 
 * @author zehong
 * @date 2024-09-07
 */
@RestController
@RequestMapping("/emergency/step")
public class TEmergencyDisposeStepController extends BaseController
{
    @Autowired
    private ITEmergencyDisposeStepService tEmergencyDisposeStepService;

    /**
     * 查询应急处置步骤列表
     */
    //@PreAuthorize("@ss.hasPermi('system:step:list')")
    @GetMapping("/list")
    public TableDataInfo list(TEmergencyDisposeStep tEmergencyDisposeStep)
    {
        startPage();
        List<TEmergencyDisposeStep> list = tEmergencyDisposeStepService.selectTEmergencyDisposeStepList(tEmergencyDisposeStep);
        return getDataTable(list);
    }


    @GetMapping("/stepListInfo")
    public AjaxResult stepListInfo(TEmergencyDisposeStep tEmergencyDisposeStep)
    {
        List<TEmergencyDisposeStep> list = tEmergencyDisposeStepService.selectTEmergencyDisposeStepList(tEmergencyDisposeStep);
        return AjaxResult.success(list);
    }

    /**
     * 导出应急处置步骤列表
     */
    //@PreAuthorize("@ss.hasPermi('system:step:export')")
    @Log(title = "应急处置步骤", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TEmergencyDisposeStep tEmergencyDisposeStep)
    {
        List<TEmergencyDisposeStep> list = tEmergencyDisposeStepService.selectTEmergencyDisposeStepList(tEmergencyDisposeStep);
        ExcelUtil<TEmergencyDisposeStep> util = new ExcelUtil<TEmergencyDisposeStep>(TEmergencyDisposeStep.class);
        return util.exportExcel(list, "应急处置步骤数据");
    }

    /**
     * 获取应急处置步骤详细信息
     */
    //@PreAuthorize("@ss.hasPermi('system:step:query')")
    @GetMapping(value = "/{stepId}")
    public AjaxResult getInfo(@PathVariable("stepId") Long stepId)
    {
        return AjaxResult.success(tEmergencyDisposeStepService.selectTEmergencyDisposeStepById(stepId));
    }

    /**
     * 新增应急处置步骤
     */
    //@PreAuthorize("@ss.hasPermi('system:step:add')")
    @Log(title = "应急处置步骤", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TEmergencyDisposeStep tEmergencyDisposeStep)
    {
        return toAjax(tEmergencyDisposeStepService.insertTEmergencyDisposeStep(tEmergencyDisposeStep));
    }

    /**
     * 修改应急处置步骤
     */
    //@PreAuthorize("@ss.hasPermi('system:step:edit')")
    @Log(title = "应急处置步骤", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TEmergencyDisposeStep tEmergencyDisposeStep)
    {
        return toAjax(tEmergencyDisposeStepService.updateTEmergencyDisposeStep(tEmergencyDisposeStep));
    }

    /**
     * 删除应急处置步骤
     */
    //@PreAuthorize("@ss.hasPermi('system:step:remove')")
    @Log(title = "应急处置步骤", businessType = BusinessType.DELETE)
	@DeleteMapping("/{stepIds}")
    public AjaxResult remove(@PathVariable Long[] stepIds)
    {
        return toAjax(tEmergencyDisposeStepService.deleteTEmergencyDisposeStepByIds(stepIds));
    }
}
