package com.zehong.web.controller.dangerinspect;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TDangerInspectTemplateInfo;
import com.zehong.system.service.ITDangerInspectTemplateInfoService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 隐患日常巡检模版Controller
 * 
 * @author zehong
 * @date 2024-12-16
 */
@RestController
@RequestMapping("/dangerInspect/template")
public class TDangerInspectTemplateInfoController extends BaseController
{
    @Autowired
    private ITDangerInspectTemplateInfoService tDangerInspectTemplateInfoService;

    /**
     * 查询隐患日常巡检模版列表
     */
    //@PreAuthorize("@ss.hasPermi('system:info:list')")
    @GetMapping("/list")
    public TableDataInfo list(TDangerInspectTemplateInfo tDangerInspectTemplateInfo)
    {
        startPage();
        List<TDangerInspectTemplateInfo> list = tDangerInspectTemplateInfoService.selectTDangerInspectTemplateInfoList(tDangerInspectTemplateInfo);
        return getDataTable(list);
    }


    @GetMapping("/dangerInspectTemplateList")
    public AjaxResult dangerInspectTemplateList(TDangerInspectTemplateInfo tDangerInspectTemplateInfo)
    {
        List<TDangerInspectTemplateInfo> list = tDangerInspectTemplateInfoService.selectTDangerInspectTemplateInfoList(tDangerInspectTemplateInfo);
        return AjaxResult.success(list);
    }

    /**
     * 导出隐患日常巡检模版列表
     */
    //@PreAuthorize("@ss.hasPermi('system:info:export')")
    @Log(title = "隐患日常巡检模版", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TDangerInspectTemplateInfo tDangerInspectTemplateInfo)
    {
        List<TDangerInspectTemplateInfo> list = tDangerInspectTemplateInfoService.selectTDangerInspectTemplateInfoList(tDangerInspectTemplateInfo);
        ExcelUtil<TDangerInspectTemplateInfo> util = new ExcelUtil<TDangerInspectTemplateInfo>(TDangerInspectTemplateInfo.class);
        return util.exportExcel(list, "隐患日常巡检模版数据");
    }

    /**
     * 获取隐患日常巡检模版详细信息
     */
    //@PreAuthorize("@ss.hasPermi('system:info:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(tDangerInspectTemplateInfoService.selectTDangerInspectTemplateInfoById(id));
    }

    /**
     * 新增隐患日常巡检模版
     */
    //@PreAuthorize("@ss.hasPermi('system:info:add')")
    @Log(title = "隐患日常巡检模版", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TDangerInspectTemplateInfo tDangerInspectTemplateInfo)
    {
        return toAjax(tDangerInspectTemplateInfoService.insertTDangerInspectTemplateInfo(tDangerInspectTemplateInfo));
    }

    /**
     * 修改隐患日常巡检模版
     */
    //@PreAuthorize("@ss.hasPermi('system:info:edit')")
    @Log(title = "隐患日常巡检模版", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TDangerInspectTemplateInfo tDangerInspectTemplateInfo)
    {
        return toAjax(tDangerInspectTemplateInfoService.updateTDangerInspectTemplateInfo(tDangerInspectTemplateInfo));
    }

    /**
     * 删除隐患日常巡检模版
     */
   // @PreAuthorize("@ss.hasPermi('system:info:remove')")
    @Log(title = "隐患日常巡检模版", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(tDangerInspectTemplateInfoService.deleteTDangerInspectTemplateInfoByIds(ids));
    }
}
