import request from '@/utils/request'

// 查询事故台账列表
export function listFailure(query) {
  return request({
    url: '/book/failure/list',
    method: 'get',
    params: query
  })
}

// 查询事故台账详细
export function getFailure(id) {
  return request({
    url: '/book/failure/' + id,
    method: 'get'
  })
}

// 新增事故台账
export function addFailure(data) {
  return request({
    url: '/book/failure',
    method: 'post',
    data: data
  })
}

// 修改事故台账
export function updateFailure(data) {
  return request({
    url: '/book/failure',
    method: 'put',
    data: data
  })
}

// 删除事故台账
export function delFailure(id) {
  return request({
    url: '/book/failure/' + id,
    method: 'delete'
  })
}

// 导出事故台账
export function exportFailure(query) {
  return request({
    url: '/book/failure/export',
    method: 'get',
    params: query
  })
}
