package com.zehong.system.service.impl;

import java.util.List;
import com.zehong.common.utils.DateUtils;
import com.zehong.system.domain.TDanger;
import com.zehong.system.mapper.TDangerMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TSiteTaskInspectMapper;
import com.zehong.system.domain.TSiteTaskInspect;
import com.zehong.system.service.ITSiteTaskInspectService;
import org.springframework.transaction.annotation.Transactional;

/**
 * 场站巡检执行Service业务层处理
 * 
 * @author zehong
 * @date 2023-12-15
 */
@Service
public class TSiteTaskInspectServiceImpl implements ITSiteTaskInspectService 
{
    @Autowired
    private TSiteTaskInspectMapper tSiteTaskInspectMapper;
    @Autowired
    private TDangerMapper tDangerMapper;

    /**
     * 查询场站巡检执行
     * 
     * @param id 场站巡检执行ID
     * @return 场站巡检执行
     */
    @Override
    public TSiteTaskInspect selectTSiteTaskInspectById(Long id)
    {
        return tSiteTaskInspectMapper.selectTSiteTaskInspectById(id);
    }

    /**
     * 查询场站巡检执行列表
     * 
     * @param tSiteTaskInspect 场站巡检执行
     * @return 场站巡检执行
     */
    @Override
    public List<TSiteTaskInspect> selectTSiteTaskInspectList(TSiteTaskInspect tSiteTaskInspect)
    {
        return tSiteTaskInspectMapper.selectTSiteTaskInspectList(tSiteTaskInspect);
    }

    /**
     * 新增场站巡检执行
     * 
     * @param tSiteTaskInspect 场站巡检执行
     * @return 结果
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public int insertTSiteTaskInspect(TSiteTaskInspect tSiteTaskInspect)
    {
        tSiteTaskInspect.setCreateTime(DateUtils.getNowDate());
        int a = tSiteTaskInspectMapper.insertTSiteTaskInspect(tSiteTaskInspect);
        if(tSiteTaskInspect.getDangerarr()!=null&&tSiteTaskInspect.getDangerarr().length>0){
            TDanger d = new TDanger();
            for(Long i :tSiteTaskInspect.getDangerarr()){
                d.setId(i);
                d.setInspectId(tSiteTaskInspect.getId());
                d.setStatus(0);
                d.setReceiveId(tSiteTaskInspect.getSiteId());
                tDangerMapper.updateTDanger(d);
            }
        }
        return a;
    }

    /**
     * 修改场站巡检执行
     * 
     * @param tSiteTaskInspect 场站巡检执行
     * @return 结果
     */
    @Override
    public int updateTSiteTaskInspect(TSiteTaskInspect tSiteTaskInspect)
    {
        return tSiteTaskInspectMapper.updateTSiteTaskInspect(tSiteTaskInspect);
    }

    /**
     * 批量删除场站巡检执行
     * 
     * @param ids 需要删除的场站巡检执行ID
     * @return 结果
     */
    @Override
    public int deleteTSiteTaskInspectByIds(Long[] ids)
    {
        return tSiteTaskInspectMapper.deleteTSiteTaskInspectByIds(ids);
    }

    /**
     * 删除场站巡检执行信息
     * 
     * @param id 场站巡检执行ID
     * @return 结果
     */
    @Override
    public int deleteTSiteTaskInspectById(Long id)
    {
        return tSiteTaskInspectMapper.deleteTSiteTaskInspectById(id);
    }


    /**
     * 场站巡检记录
     * @param tSiteTaskInspect 巡检实体
     * @return
     */
    @Override
    public List<TSiteTaskInspect> selectSiteStationInspectInfo(TSiteTaskInspect tSiteTaskInspect){
        return tSiteTaskInspectMapper.selectSiteStationInspectInfo(tSiteTaskInspect);
    }
}
