import request from '@/utils/request'

// 查询设备巡检执行列表
export function listInspect(query) {
  return request({
    url: '/device/inspect/list',
    method: 'get',
    params: query
  })
}

// 查询设备巡检执行详细
export function getInspect(id) {
  return request({
    url: '/device/inspect/' + id,
    method: 'get'
  })
}

// 新增设备巡检执行
export function addInspect(data) {
  return request({
    url: '/device/inspect',
    method: 'post',
    data: data
  })
}

// 修改设备巡检执行
export function updateInspect(data) {
  return request({
    url: '/device/inspect',
    method: 'put',
    data: data
  })
}

// 删除设备巡检执行
export function delInspect(id) {
  return request({
    url: '/device/inspect/' + id,
    method: 'delete'
  })
}

// 导出设备巡检执行
export function exportInspect(query) {
  return request({
    url: '/device/inspect/export',
    method: 'get',
    params: query
  })
}

//设备巡检信息
export function selectTDeviceTaskInspectInfoList(query) {
  return request({
    url: '/device/inspect/selectTDeviceTaskInspectInfoList',
    method: 'get',
    params: query
  })
}
