package com.zehong.system.service.impl;

import java.util.List;
import com.zehong.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TUrgentContactsMapper;
import com.zehong.system.domain.TUrgentContacts;
import com.zehong.system.service.ITUrgentContactsService;

/**
 * 应急联系人Service业务层处理
 * 
 * @author zehong
 * @date 2023-12-19
 */
@Service
public class TUrgentContactsServiceImpl implements ITUrgentContactsService 
{
    @Autowired
    private TUrgentContactsMapper tUrgentContactsMapper;

    /**
     * 查询应急联系人
     * 
     * @param id 应急联系人ID
     * @return 应急联系人
     */
    @Override
    public TUrgentContacts selectTUrgentContactsById(Long id)
    {
        return tUrgentContactsMapper.selectTUrgentContactsById(id);
    }

    /**
     * 查询应急联系人列表
     * 
     * @param tUrgentContacts 应急联系人
     * @return 应急联系人
     */
    @Override
    public List<TUrgentContacts> selectTUrgentContactsList(TUrgentContacts tUrgentContacts)
    {
        return tUrgentContactsMapper.selectTUrgentContactsList(tUrgentContacts);
    }

    /**
     * 新增应急联系人
     * 
     * @param tUrgentContacts 应急联系人
     * @return 结果
     */
    @Override
    public int insertTUrgentContacts(TUrgentContacts tUrgentContacts)
    {
        tUrgentContacts.setCreateTime(DateUtils.getNowDate());
        return tUrgentContactsMapper.insertTUrgentContacts(tUrgentContacts);
    }

    /**
     * 修改应急联系人
     * 
     * @param tUrgentContacts 应急联系人
     * @return 结果
     */
    @Override
    public int updateTUrgentContacts(TUrgentContacts tUrgentContacts)
    {
        return tUrgentContactsMapper.updateTUrgentContacts(tUrgentContacts);
    }

    /**
     * 批量删除应急联系人
     * 
     * @param ids 需要删除的应急联系人ID
     * @return 结果
     */
    @Override
    public int deleteTUrgentContactsByIds(Long[] ids)
    {
        return tUrgentContactsMapper.deleteTUrgentContactsByIds(ids);
    }

    /**
     * 删除应急联系人信息
     * 
     * @param id 应急联系人ID
     * @return 结果
     */
    @Override
    public int deleteTUrgentContactsById(Long id)
    {
        return tUrgentContactsMapper.deleteTUrgentContactsById(id);
    }
}
