package com.zehong.system.service.impl;

import java.util.List;
import com.zehong.common.utils.DateUtils;
import com.zehong.system.domain.TDanger;
import com.zehong.system.domain.TDeviceInfo;
import com.zehong.system.domain.TDeviceTask;
import com.zehong.system.mapper.TDangerMapper;
import com.zehong.system.mapper.TDeviceInfoMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TDeviceTaskInspectMapper;
import com.zehong.system.domain.TDeviceTaskInspect;
import com.zehong.system.service.ITDeviceTaskInspectService;
import org.springframework.transaction.annotation.Transactional;

/**
 * 设备巡检执行Service业务层处理
 * 
 * @author zehong
 * @date 2023-12-11
 */
@Service
public class TDeviceTaskInspectServiceImpl implements ITDeviceTaskInspectService 
{
    @Autowired
    private TDeviceTaskInspectMapper tDeviceTaskInspectMapper;
    @Autowired
    private TDeviceInfoMapper tDeviceInfoMapper;
    @Autowired
    private TDangerMapper tDangerMapper;

    /**
     * 查询设备巡检执行
     * 
     * @param id 设备巡检执行ID
     * @return 设备巡检执行
     */
    @Override
    public TDeviceTaskInspect selectTDeviceTaskInspectById(Long id)
    {
        return tDeviceTaskInspectMapper.selectTDeviceTaskInspectById(id);
    }

    /**
     * 查询设备巡检执行列表
     * 
     * @param tDeviceTaskInspect 设备巡检执行
     * @return 设备巡检执行
     */
    @Override
    public List<TDeviceTaskInspect> selectTDeviceTaskInspectList(TDeviceTaskInspect tDeviceTaskInspect)
    {
        return tDeviceTaskInspectMapper.selectTDeviceTaskInspectList(tDeviceTaskInspect);
    }

    /**
     * 设备检测情况列表
     * @param
     * @return
     */
    @Override
    public List<TDeviceInfo> deviceInspectList(TDeviceInfo tDeviceInfo)
    {
        return tDeviceInfoMapper.deviceInspectList(tDeviceInfo);
    }

    /**
     * 新增设备巡检执行
     * 
     * @param tDeviceTaskInspect 设备巡检执行
     * @return 结果
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public int insertTDeviceTaskInspect(TDeviceTaskInspect tDeviceTaskInspect)
    {
        tDeviceTaskInspect.setCreateTime(DateUtils.getNowDate());
        Integer a = tDeviceTaskInspectMapper.insertTDeviceTaskInspect(tDeviceTaskInspect);
        if(tDeviceTaskInspect.getDangerarr()!=null&&tDeviceTaskInspect.getDangerarr().length>0){
            TDanger d = new TDanger();
            for(Long i :tDeviceTaskInspect.getDangerarr()){
                d.setId(i);
                d.setInspectId(tDeviceTaskInspect.getId());
                d.setStatus(0);
                d.setReceiveId(tDeviceTaskInspect.getDeviceId());
                tDangerMapper.updateTDanger(d);
            }
        }
        return a;
    }

    /**
     * 修改设备巡检执行
     * 
     * @param tDeviceTaskInspect 设备巡检执行
     * @return 结果
     */
    @Override
    public int updateTDeviceTaskInspect(TDeviceTaskInspect tDeviceTaskInspect)
    {
        return tDeviceTaskInspectMapper.updateTDeviceTaskInspect(tDeviceTaskInspect);
    }

    /**
     * 批量删除设备巡检执行
     * 
     * @param ids 需要删除的设备巡检执行ID
     * @return 结果
     */
    @Override
    public int deleteTDeviceTaskInspectByIds(Long[] ids)
    {
        return tDeviceTaskInspectMapper.deleteTDeviceTaskInspectByIds(ids);
    }

    /**
     * 删除设备巡检执行信息
     * 
     * @param id 设备巡检执行ID
     * @return 结果
     */
    @Override
    public int deleteTDeviceTaskInspectById(Long id)
    {
        return tDeviceTaskInspectMapper.deleteTDeviceTaskInspectById(id);
    }

    /**
     * 设备巡检信息
     * @param tDeviceTaskInspect 巡检实体
     * @return
     */
    @Override
    public List<TDeviceTaskInspect> selectTDeviceTaskInspectInfoList(TDeviceTaskInspect tDeviceTaskInspect){
        return tDeviceTaskInspectMapper.selectTDeviceTaskInspectInfoList(tDeviceTaskInspect);
    }


}
