package com.zehong.system.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 居民用户对象 t_user
 * 
 * @author zehong
 * @date 2023-11-03
 */
public class TUser extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** $column.columnComment */
    private Long id;

    //表具编号
    @Excel(name = "表具编号")
    private String meternum;

    /** 用户编号（表号） */
    @Excel(name = "用户编号")
    private String usernum;

    @Excel(name = "所属区")
    private String countyName;

    @Excel(name = "所属街道")
    private String streetName;

    @Excel(name = "所属小区")
    private String villageName;

    private Long city;

    /** 所属区（县） */
    private Long county;

    /** 所属街道（乡镇） */
    private Long street;

    /** 所属小区（村 */
    private Long village;

    /** 具体地址 */
    @Excel(name = "具体地址")
    private String address;

    /** 用户姓名 */
    @Excel(name = "用户姓名")
    private String username;

    /** 联系电话 */
    @Excel(name = "联系电话")
    private String phone;

    //身份证
    @Excel(name = "身份证")
    private String idcard;

    //身份证
    @Excel(name = "营业网点", dictType = "t_branch")
    private String branch;


    /** 表计类型(字典) */
    //@Excel(name = "表计类型",dictType = "t_meter_type")
    private String type;

    /** 开通状态（字典表 */
    @Excel(name = "开通状态", dictType = "t_user_status")
    private String status;

    /** 通气日期 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "通气日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date starttime;

    /** 用气设施（字典表） */
    //@Excel(name = "用气设施", dictType = "t_user_scene")
    private String device;

    /** 表具类型1皮膜2超声 */
    //@Excel(name = "表具类型1皮膜2超声")
    private Integer meterType;

    /** 表具厂家1金卡2秦川 */
    @Excel(name = "表具厂家" ,dictType = "t_meter_company" )
    private Integer meterCompany;

    /** 表具型号1 G1.5、2 G2.5、3 G4 */
    //@Excel(name = "表具型号1 G1.5、2 G2.5、3 G4")
    private Integer meterModel;

    /** 进气方向1左2右 */
    @Excel(name = "进气方向1左2右")
    private Long direction;

    /** 最新任务编号 */
    @Excel(name = "最新任务编号")
    private Long taskId;

    private String latitude;
    private String longitude;

    //最新安检状态
    private Integer ajstatus;
    private String deviceName;

    private String soutext;

    private Integer selectFrom;

    private Long community;

    @Excel(name = "用户照片")
    private String imgurl;

    /** 表具位置，1单元屋内，2单元屋外，3院内，4院外 */
    @Excel(name = "表具位置",dictType = "t_meter_position")
    private String position;

    /** 安检用户，1小区用户，2气代煤用户，3孤寡老人用户 */
    @Excel(name = "安检用户",dictType = "t_inspect_user_type")
    private String taskType;

    //用户信息
    private String userInfo;


    public String getMeternum() {
        return meternum;
    }

    public void setMeternum(String meternum) {
        this.meternum = meternum;
    }

    public String getIdcard() {
        return idcard;
    }

    public void setIdcard(String idcard) {
        this.idcard = idcard;
    }

    public String getBranch() {
        return branch;
    }

    public void setBranch(String branch) {
        this.branch = branch;
    }

    public Integer getSelectFrom() {
        return selectFrom;
    }

    public void setSelectFrom(Integer selectFrom) {
        this.selectFrom = selectFrom;
    }

    public String getSoutext() {
        return soutext;
    }

    public void setSoutext(String soutext) {
        this.soutext = soutext;
    }

    public String getDeviceName() {
        return deviceName;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    public Integer getAjstatus() {
        return ajstatus;
    }

    public void setAjstatus(Integer ajstatus) {
        this.ajstatus = ajstatus;
    }

    public String getStreetName() {
        return streetName;
    }

    public void setStreetName(String streetName) {
        this.streetName = streetName;
    }

    public String getVillageName() {
        return villageName;
    }

    public void setVillageName(String villageName) {
        this.villageName = villageName;
    }

    public String getCountyName() {
        return countyName;
    }

    public void setCountyName(String countyName) {
        this.countyName = countyName;
    }

    public String getLatitude() {
        return latitude;
    }

    public void setLatitude(String latitude) {
        this.latitude = latitude;
    }

    public String getLongitude() {
        return longitude;
    }

    public void setLongitude(String longitude) {
        this.longitude = longitude;
    }

    public void setId(Long id)
    {
        this.id = id;
    }

    public Long getId() 
    {
        return id;
    }
    public void setUsernum(String usernum) 
    {
        this.usernum = usernum;
    }

    public String getUsernum() 
    {
        return usernum;
    }
    public void setCounty(Long county) 
    {
        this.county = county;
    }

    public Long getCity() {
        return city;
    }

    public void setCity(Long city) {
        this.city = city;
    }

    public Long getCounty()
    {
        return county;
    }
    public void setStreet(Long street) 
    {
        this.street = street;
    }

    public Long getStreet() 
    {
        return street;
    }
    public void setVillage(Long village) 
    {
        this.village = village;
    }

    public Long getVillage() 
    {
        return village;
    }
    public void setAddress(String address) 
    {
        this.address = address;
    }

    public String getAddress() 
    {
        return address;
    }
    public void setUsername(String username) 
    {
        this.username = username;
    }

    public String getUsername() 
    {
        return username;
    }
    public void setPhone(String phone) 
    {
        this.phone = phone;
    }

    public String getPhone() 
    {
        return phone;
    }
    public void setType(String type) 
    {
        this.type = type;
    }

    public String getType() 
    {
        return type;
    }
    public void setStatus(String status) 
    {
        this.status = status;
    }

    public String getStatus() 
    {
        return status;
    }
    public void setStarttime(Date starttime) 
    {
        this.starttime = starttime;
    }

    public Date getStarttime() 
    {
        return starttime;
    }
    public void setDevice(String device) 
    {
        this.device = device;
    }

    public String getDevice() 
    {
        return device;
    }
    public void setMeterType(Integer meterType) 
    {
        this.meterType = meterType;
    }

    public Integer getMeterType() 
    {
        return meterType;
    }
    public void setMeterCompany(Integer meterCompany) 
    {
        this.meterCompany = meterCompany;
    }

    public Integer getMeterCompany() 
    {
        return meterCompany;
    }
    public void setMeterModel(Integer meterModel) 
    {
        this.meterModel = meterModel;
    }

    public Integer getMeterModel() 
    {
        return meterModel;
    }
    public void setDirection(Long direction) 
    {
        this.direction = direction;
    }

    public Long getDirection() 
    {
        return direction;
    }
    public void setTaskId(Long taskId) 
    {
        this.taskId = taskId;
    }

    public Long getTaskId() 
    {
        return taskId;
    }

    public Long getCommunity() {
        return community;
    }

    public void setCommunity(Long community) {
        this.community = community;
    }

    public String getImgurl() {
        return imgurl;
    }

    public void setImgurl(String imgurl) {
        this.imgurl = imgurl;
    }

    public String getPosition() {
        return position;
    }

    public void setPosition(String position) {
        this.position = position;
    }

    public String getTaskType() {
        return taskType;
    }

    public void setTaskType(String taskType) {
        this.taskType = taskType;
    }

    public String getUserInfo() {
        return userInfo;
    }

    public void setUserInfo(String userInfo) {
        this.userInfo = userInfo;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("usernum", getUsernum())
            .append("county", getCounty())
            .append("street", getStreet())
            .append("village", getVillage())
            .append("address", getAddress())
            .append("username", getUsername())
            .append("phone", getPhone())
            .append("type", getType())
            .append("status", getStatus())
            .append("starttime", getStarttime())
            .append("device", getDevice())
            .append("meterType", getMeterType())
            .append("meterCompany", getMeterCompany())
            .append("meterModel", getMeterModel())
            .append("direction", getDirection())
            .append("taskId", getTaskId())
            .append("remark", getRemark())
            .toString();
    }
}
