package com.zehong.web.controller.devicemanage;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TSiteTask;
import com.zehong.system.service.ITSiteTaskService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 场站巡检任务Controller
 * 
 * @author zehong
 * @date 2023-12-15
 */
@RestController
@RequestMapping("/site/task")
public class TSiteTaskController extends BaseController
{
    @Autowired
    private ITSiteTaskService tSiteTaskService;

    /**
     * 查询场站巡检任务列表
     */
    //@PreAuthorize("@ss.hasPermi('site:task:list')")
    @GetMapping("/list")
    public TableDataInfo list(TSiteTask tSiteTask)
    {
        startPage();
        List<TSiteTask> list = tSiteTaskService.selectTSiteTaskList(tSiteTask);
        return getDataTable(list);
    }

    @GetMapping("/wxlist")
    public TableDataInfo wxlist(TSiteTask tSiteTask)
    {
        startPage();
        List<TSiteTask> list = tSiteTaskService.selectTSiteTaskwxList(tSiteTask);
        return getDataTable(list);
    }
    /**
     * 导出场站巡检任务列表
     */
    //@PreAuthorize("@ss.hasPermi('site:task:export')")
    @Log(title = "场站巡检任务", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TSiteTask tSiteTask)
    {
        List<TSiteTask> list = tSiteTaskService.selectTSiteTaskList(tSiteTask);
        ExcelUtil<TSiteTask> util = new ExcelUtil<TSiteTask>(TSiteTask.class);
        return util.exportExcel(list, "场站巡检任务数据");
    }

    /**
     * 获取场站巡检任务详细信息
     */
    //@PreAuthorize("@ss.hasPermi('site:task:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(tSiteTaskService.selectTSiteTaskById(id));
    }

    /**
     * 新增场站巡检任务
     */
    //@PreAuthorize("@ss.hasPermi('site:task:add')")
    @Log(title = "场站巡检任务", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TSiteTask tSiteTask)
    {
        return toAjax(tSiteTaskService.insertTSiteTask(tSiteTask));
    }

    /**
     * 修改场站巡检任务
     */
    //@PreAuthorize("@ss.hasPermi('site:task:edit')")
    @Log(title = "场站巡检任务", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TSiteTask tSiteTask)
    {
        return toAjax(tSiteTaskService.updateTSiteTask(tSiteTask));
    }

    /**
     * 删除场站巡检任务
     */
    //@PreAuthorize("@ss.hasPermi('site:task:remove')")
    @Log(title = "场站巡检任务", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(tSiteTaskService.deleteTSiteTaskByIds(ids));
    }
}
