package com.zehong.system.service.impl;

import java.util.List;
import com.zehong.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TInspectionPlanMapper;
import com.zehong.system.domain.TInspectionPlan;
import com.zehong.system.service.ITInspectionPlanService;

/**
 * 巡检计划Service业务层处理
 * 
 * @author zehong
 * @date 2021-07-21
 */
@Service
public class TInspectionPlanServiceImpl implements ITInspectionPlanService 
{
    @Autowired
    private TInspectionPlanMapper tInspectionPlanMapper;

    /**
     * 查询巡检计划
     * 
     * @param planId 巡检计划ID
     * @return 巡检计划
     */
    @Override
    public TInspectionPlan selectTInspectionPlanById(Long planId)
    {
        return tInspectionPlanMapper.selectTInspectionPlanById(planId);
    }

    /**
     * 查询巡检计划列表
     * 
     * @param tInspectionPlan 巡检计划
     * @return 巡检计划
     */
    @Override
    public List<TInspectionPlan> selectTInspectionPlanList(TInspectionPlan tInspectionPlan)
    {
        return tInspectionPlanMapper.selectTInspectionPlanList(tInspectionPlan);
    }

    /**
     * 新增巡检计划
     * 
     * @param tInspectionPlan 巡检计划
     * @return 结果
     */
    @Override
    public int insertTInspectionPlan(TInspectionPlan tInspectionPlan)
    {
        tInspectionPlan.setCreateTime(DateUtils.getNowDate());
        return tInspectionPlanMapper.insertTInspectionPlan(tInspectionPlan);
    }

    /**
     * 修改巡检计划
     * 
     * @param tInspectionPlan 巡检计划
     * @return 结果
     */
    @Override
    public int updateTInspectionPlan(TInspectionPlan tInspectionPlan)
    {
        tInspectionPlan.setUpdateTime(DateUtils.getNowDate());
        return tInspectionPlanMapper.updateTInspectionPlan(tInspectionPlan);
    }

    /**
     * 批量删除巡检计划
     * 
     * @param planIds 需要删除的巡检计划ID
     * @return 结果
     */
    @Override
    public int deleteTInspectionPlanByIds(Long[] planIds)
    {
        return tInspectionPlanMapper.deleteTInspectionPlanByIds(planIds);
    }

    /**
     * 删除巡检计划信息
     * 
     * @param planId 巡检计划ID
     * @return 结果
     */
    @Override
    public int deleteTInspectionPlanById(Long planId)
    {
        return tInspectionPlanMapper.deleteTInspectionPlanById(planId);
    }
}
