package com.zehong.system.service.impl;

import java.util.List;
import com.zehong.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TInspectionDataMapper;
import com.zehong.system.domain.TInspectionData;
import com.zehong.system.service.ITInspectionDataService;

/**
 * 巡检记录Service业务层处理
 * 
 * @author zehong
 * @date 2021-07-21
 */
@Service
public class TInspectionDataServiceImpl implements ITInspectionDataService 
{
    @Autowired
    private TInspectionDataMapper tInspectionDataMapper;

    /**
     * 查询巡检记录
     * 
     * @param dataId 巡检记录ID
     * @return 巡检记录
     */
    @Override
    public TInspectionData selectTInspectionDataById(Long dataId)
    {
        return tInspectionDataMapper.selectTInspectionDataById(dataId);
    }

    /**
     * 查询巡检记录列表
     * 
     * @param tInspectionData 巡检记录
     * @return 巡检记录
     */
    @Override
    public List<TInspectionData> selectTInspectionDataList(TInspectionData tInspectionData)
    {
        return tInspectionDataMapper.selectTInspectionDataList(tInspectionData);
    }

    /**
     * 新增巡检记录
     * 
     * @param tInspectionData 巡检记录
     * @return 结果
     */
    @Override
    public int insertTInspectionData(TInspectionData tInspectionData)
    {
        tInspectionData.setCreateTime(DateUtils.getNowDate());
        return tInspectionDataMapper.insertTInspectionData(tInspectionData);
    }

    /**
     * 修改巡检记录
     * 
     * @param tInspectionData 巡检记录
     * @return 结果
     */
    @Override
    public int updateTInspectionData(TInspectionData tInspectionData)
    {
        tInspectionData.setUpdateTime(DateUtils.getNowDate());
        return tInspectionDataMapper.updateTInspectionData(tInspectionData);
    }

    /**
     * 批量删除巡检记录
     * 
     * @param dataIds 需要删除的巡检记录ID
     * @return 结果
     */
    @Override
    public int deleteTInspectionDataByIds(Long[] dataIds)
    {
        return tInspectionDataMapper.deleteTInspectionDataByIds(dataIds);
    }

    /**
     * 删除巡检记录信息
     * 
     * @param dataId 巡检记录ID
     * @return 结果
     */
    @Override
    public int deleteTInspectionDataById(Long dataId)
    {
        return tInspectionDataMapper.deleteTInspectionDataById(dataId);
    }
}
