package com.zehong.system.service.impl;

import java.util.List;
import com.zehong.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.THiddenTroubleMapper;
import com.zehong.system.domain.THiddenTrouble;
import com.zehong.system.service.ITHiddenTroubleService;

/**
 * 隐患信息Service业务层处理
 * 
 * @author zehong
 * @date 2021-07-21
 */
@Service
public class THiddenTroubleServiceImpl implements ITHiddenTroubleService 
{
    @Autowired
    private THiddenTroubleMapper tHiddenTroubleMapper;

    /**
     * 查询隐患信息
     * 
     * @param troubleId 隐患信息ID
     * @return 隐患信息
     */
    @Override
    public THiddenTrouble selectTHiddenTroubleById(Long troubleId)
    {
        return tHiddenTroubleMapper.selectTHiddenTroubleById(troubleId);
    }

    /**
     * 查询隐患信息列表
     * 
     * @param tHiddenTrouble 隐患信息
     * @return 隐患信息
     */
    @Override
    public List<THiddenTrouble> selectTHiddenTroubleList(THiddenTrouble tHiddenTrouble)
    {
        return tHiddenTroubleMapper.selectTHiddenTroubleList(tHiddenTrouble);
    }

    /**
     * 新增隐患信息
     * 
     * @param tHiddenTrouble 隐患信息
     * @return 结果
     */
    @Override
    public int insertTHiddenTrouble(THiddenTrouble tHiddenTrouble)
    {
        tHiddenTrouble.setCreateTime(DateUtils.getNowDate());
        return tHiddenTroubleMapper.insertTHiddenTrouble(tHiddenTrouble);
    }

    /**
     * 修改隐患信息
     * 
     * @param tHiddenTrouble 隐患信息
     * @return 结果
     */
    @Override
    public int updateTHiddenTrouble(THiddenTrouble tHiddenTrouble)
    {
        tHiddenTrouble.setUpdateTime(DateUtils.getNowDate());
        return tHiddenTroubleMapper.updateTHiddenTrouble(tHiddenTrouble);
    }

    /**
     * 批量删除隐患信息
     * 
     * @param troubleIds 需要删除的隐患信息ID
     * @return 结果
     */
    @Override
    public int deleteTHiddenTroubleByIds(Long[] troubleIds)
    {
        return tHiddenTroubleMapper.deleteTHiddenTroubleByIds(troubleIds);
    }

    /**
     * 删除隐患信息信息
     * 
     * @param troubleId 隐患信息ID
     * @return 结果
     */
    @Override
    public int deleteTHiddenTroubleById(Long troubleId)
    {
        return tHiddenTroubleMapper.deleteTHiddenTroubleById(troubleId);
    }
}
