package com.zehong.system.service.impl;

import java.util.List;
import com.zehong.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TDeviceAlarmMapper;
import com.zehong.system.domain.TDeviceAlarm;
import com.zehong.system.service.ITDeviceAlarmService;

/**
 * 报警信息Service业务层处理
 * 
 * @author zehong
 * @date 2021-07-21
 */
@Service
public class TDeviceAlarmServiceImpl implements ITDeviceAlarmService 
{
    @Autowired
    private TDeviceAlarmMapper tDeviceAlarmMapper;

    /**
     * 查询报警信息
     * 
     * @param alarmId 报警信息ID
     * @return 报警信息
     */
    @Override
    public TDeviceAlarm selectTDeviceAlarmById(Long alarmId)
    {
        return tDeviceAlarmMapper.selectTDeviceAlarmById(alarmId);
    }

    /**
     * 查询报警信息列表
     * 
     * @param tDeviceAlarm 报警信息
     * @return 报警信息
     */
    @Override
    public List<TDeviceAlarm> selectTDeviceAlarmList(TDeviceAlarm tDeviceAlarm)
    {
        return tDeviceAlarmMapper.selectTDeviceAlarmList(tDeviceAlarm);
    }

    /**
     * 新增报警信息
     * 
     * @param tDeviceAlarm 报警信息
     * @return 结果
     */
    @Override
    public int insertTDeviceAlarm(TDeviceAlarm tDeviceAlarm)
    {
        tDeviceAlarm.setCreateTime(DateUtils.getNowDate());
        return tDeviceAlarmMapper.insertTDeviceAlarm(tDeviceAlarm);
    }

    /**
     * 修改报警信息
     * 
     * @param tDeviceAlarm 报警信息
     * @return 结果
     */
    @Override
    public int updateTDeviceAlarm(TDeviceAlarm tDeviceAlarm)
    {
        tDeviceAlarm.setUpdateTime(DateUtils.getNowDate());
        return tDeviceAlarmMapper.updateTDeviceAlarm(tDeviceAlarm);
    }

    /**
     * 批量删除报警信息
     * 
     * @param alarmIds 需要删除的报警信息ID
     * @return 结果
     */
    @Override
    public int deleteTDeviceAlarmByIds(Long[] alarmIds)
    {
        return tDeviceAlarmMapper.deleteTDeviceAlarmByIds(alarmIds);
    }

    /**
     * 删除报警信息信息
     * 
     * @param alarmId 报警信息ID
     * @return 结果
     */
    @Override
    public int deleteTDeviceAlarmById(Long alarmId)
    {
        return tDeviceAlarmMapper.deleteTDeviceAlarmById(alarmId);
    }
}
