package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.TInspectionData;

/**
 * 巡检记录Service接口
 * 
 * @author zehong
 * @date 2021-07-21
 */
public interface ITInspectionDataService 
{
    /**
     * 查询巡检记录
     * 
     * @param dataId 巡检记录ID
     * @return 巡检记录
     */
    public TInspectionData selectTInspectionDataById(Long dataId);

    /**
     * 查询巡检记录列表
     * 
     * @param tInspectionData 巡检记录
     * @return 巡检记录集合
     */
    public List<TInspectionData> selectTInspectionDataList(TInspectionData tInspectionData);

    /**
     * 新增巡检记录
     * 
     * @param tInspectionData 巡检记录
     * @return 结果
     */
    public int insertTInspectionData(TInspectionData tInspectionData);

    /**
     * 修改巡检记录
     * 
     * @param tInspectionData 巡检记录
     * @return 结果
     */
    public int updateTInspectionData(TInspectionData tInspectionData);

    /**
     * 批量删除巡检记录
     * 
     * @param dataIds 需要删除的巡检记录ID
     * @return 结果
     */
    public int deleteTInspectionDataByIds(Long[] dataIds);

    /**
     * 删除巡检记录信息
     * 
     * @param dataId 巡检记录ID
     * @return 结果
     */
    public int deleteTInspectionDataById(Long dataId);
}
