package com.zehong.system.domain;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 巡检记录对象 t_inspection_data
 * 
 * @author zehong
 * @date 2021-07-21
 */
public class TInspectionData extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 巡检记录id */
    private Long dataId;

    /** 巡检计划id */
    @Excel(name = "巡检计划id")
    private Long planId;

    /** 设备id */
    @Excel(name = "设备id")
    private Long deviceId;

    /** 处理状态（1不需处理，2已处理完成，3未处理完成） */
    @Excel(name = "处理状态", readConverterExp = "1=不需处理，2已处理完成，3未处理完成")
    private String dealStatus;

    /** 备注 */
    @Excel(name = "备注")
    private String remarks;

    public void setDataId(Long dataId) 
    {
        this.dataId = dataId;
    }

    public Long getDataId() 
    {
        return dataId;
    }
    public void setPlanId(Long planId) 
    {
        this.planId = planId;
    }

    public Long getPlanId() 
    {
        return planId;
    }
    public void setDeviceId(Long deviceId) 
    {
        this.deviceId = deviceId;
    }

    public Long getDeviceId() 
    {
        return deviceId;
    }
    public void setDealStatus(String dealStatus) 
    {
        this.dealStatus = dealStatus;
    }

    public String getDealStatus() 
    {
        return dealStatus;
    }
    public void setRemarks(String remarks) 
    {
        this.remarks = remarks;
    }

    public String getRemarks() 
    {
        return remarks;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("dataId", getDataId())
            .append("planId", getPlanId())
            .append("deviceId", getDeviceId())
            .append("dealStatus", getDealStatus())
            .append("updateTime", getUpdateTime())
            .append("createTime", getCreateTime())
            .append("remarks", getRemarks())
            .toString();
    }
}
