package com.zehong.system.domain;

import java.math.BigDecimal;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 隐患信息对象 t_hidden_trouble
 * 
 * @author zehong
 * @date 2021-07-21
 */
public class THiddenTrouble extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 隐患信息id */
    private Long troubleId;

    /** 设备id */
    @Excel(name = "设备id")
    private Long deviceId;

    /** 工单id */
    @Excel(name = "工单id")
    private String orderId;

    /** 经度 */
    @Excel(name = "经度")
    private BigDecimal longitude;

    /** 纬度 */
    @Excel(name = "纬度")
    private BigDecimal latitude;

    /** 处理状态（1不需处理，2已处理完成，3未处理完成） */
    @Excel(name = "处理状态", readConverterExp = "1=不需处理，2已处理完成，3未处理完成")
    private String dealStatus;

    /** 备注 */
    @Excel(name = "备注")
    private String remarks;

    public void setTroubleId(Long troubleId) 
    {
        this.troubleId = troubleId;
    }

    public Long getTroubleId() 
    {
        return troubleId;
    }
    public void setDeviceId(Long deviceId) 
    {
        this.deviceId = deviceId;
    }

    public Long getDeviceId() 
    {
        return deviceId;
    }
    public void setOrderId(String orderId) 
    {
        this.orderId = orderId;
    }

    public String getOrderId() 
    {
        return orderId;
    }
    public void setLongitude(BigDecimal longitude) 
    {
        this.longitude = longitude;
    }

    public BigDecimal getLongitude() 
    {
        return longitude;
    }
    public void setLatitude(BigDecimal latitude) 
    {
        this.latitude = latitude;
    }

    public BigDecimal getLatitude() 
    {
        return latitude;
    }
    public void setDealStatus(String dealStatus) 
    {
        this.dealStatus = dealStatus;
    }

    public String getDealStatus() 
    {
        return dealStatus;
    }
    public void setRemarks(String remarks) 
    {
        this.remarks = remarks;
    }

    public String getRemarks() 
    {
        return remarks;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("troubleId", getTroubleId())
            .append("deviceId", getDeviceId())
            .append("orderId", getOrderId())
            .append("longitude", getLongitude())
            .append("latitude", getLatitude())
            .append("dealStatus", getDealStatus())
            .append("updateTime", getUpdateTime())
            .append("createTime", getCreateTime())
            .append("remarks", getRemarks())
            .toString();
    }
}
