import request from '@/utils/request'

// 查询报警信息列表
export function listDeviceAlarm(query) {
  return request({
    url: '/dataMonitoring/deviceAlarm/list',
    method: 'get',
    params: query
  })
}

// 查询报警信息详细
export function getDeviceAlarm(alarmId) {
  return request({
    url: '/dataMonitoring/deviceAlarm/' + alarmId,
    method: 'get'
  })
}

// 新增报警信息
export function addDeviceAlarm(data) {
  return request({
    url: '/dataMonitoring/deviceAlarm',
    method: 'post',
    data: data
  })
}

// 修改报警信息
export function updateDeviceAlarm(data) {
  return request({
    url: '/dataMonitoring/deviceAlarm',
    method: 'put',
    data: data
  })
}

// 删除报警信息
export function delDeviceAlarm(alarmId) {
  return request({
    url: '/dataMonitoring/deviceAlarm/' + alarmId,
    method: 'delete'
  })
}

// 导出报警信息
export function exportDeviceAlarm(query) {
  return request({
    url: '/dataMonitoring/deviceAlarm/export',
    method: 'get',
    params: query
  })
}



//查询报警设备
export function selectAlarmDevice() {
  return request({
    url: '/dataMonitoring/deviceAlarm/selectAlarmDevice',
    method: 'get',
    params: query
  })
}
