package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.TDeviceAlarm;
import com.zehong.system.domain.vo.DeviceAlarmVo;

/**
 * 报警信息Service接口
 * 
 * @author zehong
 * @date 2021-07-21
 */
public interface ITDeviceAlarmService 
{
    /**
     * 查询报警信息
     * 
     * @param alarmId 报警信息ID
     * @return 报警信息
     */
    public DeviceAlarmVo selectTDeviceAlarmById(int alarmId) throws Exception;

    /**
     * 查询报警信息列表
     * 
     * @param tDeviceAlarm 报警信息
     * @return 报警信息集合
     */
    public List<DeviceAlarmVo> selectTDeviceAlarmList(TDeviceAlarm tDeviceAlarm) throws Exception;

    /**
     * 新增报警信息
     * 
     * @param tDeviceAlarm 报警信息
     * @return 结果
     */
    public int insertTDeviceAlarm(TDeviceAlarm tDeviceAlarm);

    /**
     * 修改报警信息
     * 
     * @param tDeviceAlarm 报警信息
     * @return 结果
     */
    public int updateTDeviceAlarm(TDeviceAlarm tDeviceAlarm);

    /**
     * 批量删除报警信息
     * 
     * @param alarmIds 需要删除的报警信息ID
     * @return 结果
     */
    public int deleteTDeviceAlarmByIds(int[] alarmIds);

    /**
     * 删除报警信息信息
     * 
     * @param alarmId 报警信息ID
     * @return 结果
     */
    public int deleteTDeviceAlarmById(int alarmId);

    /**
     * 查询报警设备
     * @return TDeviceAlarm
     */
    List<TDeviceAlarm> selectAlarmDevice ();
}
