package com.zehong.system.domain.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.zehong.common.core.domain.BaseEntity;
import com.zehong.system.domain.TDeviceInfo;
import com.zehong.system.domain.TPipe;

import java.util.Date;

/**
 * 报警信息对象 t_device_alarm
 * 
 * @author zehong
 * @date 2021-07-21
 */
public class DeviceAlarmVo extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** $column.columnComment */
    private Integer alarmId;

    /** 设备id */
    private Integer deviceId;

    /** 设备类型（0管道，1调压阀，2阀门井，3流量计，4压力表） */
    private String deviceType;

    /** 设备名称 */
    private String deviceName;

    /** 设备编号 */
    private String deviceCode;

    /** 物联网编号 */
    private String iotNo;

    /** 工单id */
    private String orderId;

    /** 报警类型 */
    private String alarmType;

    /** 报警值（报警信息） */
    private String alarmValue;

    /** 报警开始时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date startTime;

    /** 报警结束时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date endTime;

    /** 处理状态（1不需处理，2已处理完成，3未处理完成） */
    private String dealStatus;

    public void setAlarmId(Integer alarmId)
    {
        this.alarmId = alarmId;
    }

    public Integer getAlarmId()
    {
        return alarmId;
    }

    public void setDeviceId(Integer deviceId)
    {
        this.deviceId = deviceId;
    }

    public Integer getDeviceId()
    {
        return deviceId;
    }

    public String getDeviceType() {
        return deviceType;
    }

    public void setDeviceType(String deviceType) {
        this.deviceType = deviceType;
    }

    public String getDeviceName() {
        return deviceName;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    public String getDeviceCode() {
        return deviceCode;
    }

    public void setDeviceCode(String deviceCode) {
        this.deviceCode = deviceCode;
    }

    public String getIotNo() {
        return iotNo;
    }

    public void setIotNo(String iotNo) {
        this.iotNo = iotNo;
    }

    public void setOrderId(String orderId)
    {
        this.orderId = orderId;
    }

    public String getOrderId() 
    {
        return orderId;
    }

    public void setAlarmType(String alarmType) 
    {
        this.alarmType = alarmType;
    }

    public String getAlarmType() 
    {
        return alarmType;
    }

    public void setAlarmValue(String alarmValue) 
    {
        this.alarmValue = alarmValue;
    }

    public String getAlarmValue() 
    {
        return alarmValue;
    }

    public void setStartTime(Date startTime) 
    {
        this.startTime = startTime;
    }

    public Date getStartTime() 
    {
        return startTime;
    }

    public void setEndTime(Date endTime) 
    {
        this.endTime = endTime;
    }

    public Date getEndTime() 
    {
        return endTime;
    }

    public void setDealStatus(String dealStatus) 
    {
        this.dealStatus = dealStatus;
    }

    public String getDealStatus() 
    {
        return dealStatus;
    }

}
