import request from '@/utils/request'

// 查询隐患信息列表
export function listHiddenTrouble(query) {
  return request({
    url: '/riskManagement/hiddenTrouble/list',
    method: 'get',
    params: query
  })
}

//地图隐患初始化
export function getMapHiddenTroublelist(query) {
  return request({
    url: '/riskManagement/hiddenTrouble/getMapHiddenTroublelist',
    method: 'get',
    params: query
  })
}

// 查询隐患信息详细
export function getHiddenTrouble(troubleId) {
  return request({
    url: '/riskManagement/hiddenTrouble/' + troubleId,
    method: 'get'
  })
}

// 新增隐患信息
export function addHiddenTrouble(data) {
  return request({
    url: '/riskManagement/hiddenTrouble',
    method: 'post',
    data: data
  })
}

// 修改隐患信息
export function updateHiddenTrouble(data) {
  return request({
    url: '/riskManagement/hiddenTrouble',
    method: 'put',
    data: data
  })
}

// 删除隐患信息
export function delHiddenTrouble(troubleId) {
  return request({
    url: '/riskManagement/hiddenTrouble/' + troubleId,
    method: 'delete'
  })
}

// 导出隐患信息
export function exportHiddenTrouble(query) {
  return request({
    url: '/riskManagement/hiddenTrouble/export',
    method: 'get',
    params: query
  })
}
