package com.zehong.web.controller.deviceInspection;

import com.github.pagehelper.PageInfo;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.core.page.TableDataInfo;
import com.zehong.common.enums.BusinessType;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.system.domain.TInspectionPlan;
import com.zehong.system.domain.form.InspectionPlanForm;
import com.zehong.system.domain.vo.InspectionPlanVo;
import com.zehong.system.service.ITInspectionPlanService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 巡检计划Controller
 * 
 * @author zehong
 * @date 2021-07-21
 */
@RestController
@RequestMapping("/deviceInspection/inspectionPlan")
public class TInspectionPlanController extends BaseController
{
    @Autowired
    private ITInspectionPlanService tInspectionPlanService;

    /**
     * 查询巡检计划列表
     */
    @PreAuthorize("@ss.hasPermi('deviceInspection:inspectionPlan:list')")
    @GetMapping("/list")
    public TableDataInfo list(InspectionPlanForm inspectionPlanForm)
    {
        startPage();
        PageInfo<TInspectionPlan> page = tInspectionPlanService.selectTInspectionPlanPage(inspectionPlanForm);
        return getDataTable(page);
    }

    /**
     * 导出巡检计划列表
     */
    @PreAuthorize("@ss.hasPermi('deviceInspection:inspectionPlan:export')")
    @Log(title = "巡检计划", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(InspectionPlanForm inspectionPlanForm)
    {
        List<TInspectionPlan> list = tInspectionPlanService.selectTInspectionPlanList(inspectionPlanForm);
        ExcelUtil<TInspectionPlan> util = new ExcelUtil<TInspectionPlan>(TInspectionPlan.class);
        return util.exportExcel(list, "巡检计划数据");
    }

    /**
     * 获取巡检计划详细信息
     */
    @PreAuthorize("@ss.hasPermi('deviceInspection:inspectionPlan:query')")
    @GetMapping(value = "/{planId}")
    public AjaxResult getInfo(@PathVariable("planId") int planId) throws Exception
    {
        InspectionPlanVo plan = null;
        try {
            plan = tInspectionPlanService.selectTInspectionPlanById(planId);
        } catch (Exception e) {
            e.printStackTrace();
            throw new Exception("获取巡检计划详细信息失败");
        }
        return AjaxResult.success(plan);
    }

    /**
     * 新增巡检计划
     */
    @PreAuthorize("@ss.hasPermi('deviceInspection:inspectionPlan:add')")
    @Log(title = "巡检计划", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TInspectionPlan tInspectionPlan) throws Exception
    {
        int result = 0;
        try {
            result = tInspectionPlanService.insertTInspectionPlan(tInspectionPlan);
        } catch (Exception e) {
            e.printStackTrace();
            throw new Exception("新增巡检计划失败");
        }
        return toAjax(result);
    }

    /**
     * 修改巡检计划
     */
    @PreAuthorize("@ss.hasPermi('deviceInspection:inspectionPlan:edit')")
    @Log(title = "巡检计划", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TInspectionPlan tInspectionPlan) throws Exception
    {
        int result = 0;
        try {
            result = tInspectionPlanService.updateTInspectionPlan(tInspectionPlan);
        } catch (Exception e) {
            e.printStackTrace();
            throw new Exception("修改巡检计划失败");
        }
        return toAjax(result);
    }

    /**
     * 删除巡检计划
     */
    @PreAuthorize("@ss.hasPermi('deviceInspection:inspectionPlan:remove')")
    @Log(title = "巡检计划", businessType = BusinessType.DELETE)
	@DeleteMapping("/{planIds}")
    public AjaxResult remove(@PathVariable int[] planIds)
    {
        return toAjax(tInspectionPlanService.deleteTInspectionPlanByIds(planIds));
    }
}
