package com.zehong.web.controller.device;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TVideoManager;
import com.zehong.system.service.ITVideoManagerService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 视频管理Controller
 * 
 * @author zehong
 * @date 2021-09-18
 */
@RestController
@RequestMapping("/device/manager")
public class TVideoManagerController extends BaseController
{
    @Autowired
    private ITVideoManagerService tVideoManagerService;

    /**
     * 查询视频管理列表
     */
    @PreAuthorize("@ss.hasPermi('device:manager:list')")
    @GetMapping("/list")
    public TableDataInfo list(TVideoManager tVideoManager)
    {
        startPage();
        List<TVideoManager> list = tVideoManagerService.selectTVideoManagerList(tVideoManager);
        return getDataTable(list);
    }


    @GetMapping("/videoList")
    public TableDataInfo videoList(TVideoManager tVideoManager)
    {
        return getDataTable(tVideoManagerService.selectTVideoManagerList(tVideoManager));
    }

    /**
     * 导出视频管理列表
     */
    @PreAuthorize("@ss.hasPermi('device:manager:export')")
    @Log(title = "视频管理", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TVideoManager tVideoManager)
    {
        List<TVideoManager> list = tVideoManagerService.selectTVideoManagerList(tVideoManager);
        ExcelUtil<TVideoManager> util = new ExcelUtil<TVideoManager>(TVideoManager.class);
        return util.exportExcel(list, "视频管理数据");
    }

    /**
     * 获取视频管理详细信息
     */
    @PreAuthorize("@ss.hasPermi('device:manager:query')")
    @GetMapping(value = "/{videoManagerId}")
    public AjaxResult getInfo(@PathVariable("videoManagerId") String videoManagerId)
    {
        return AjaxResult.success(tVideoManagerService.selectTVideoManagerById(videoManagerId));
    }

    /**
     * 新增视频管理
     */
    @PreAuthorize("@ss.hasPermi('device:manager:add')")
    @Log(title = "视频管理", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TVideoManager tVideoManager)
    {
        return toAjax(tVideoManagerService.insertTVideoManager(tVideoManager));
    }

    /**
     * 修改视频管理
     */
    @PreAuthorize("@ss.hasPermi('device:manager:edit')")
    @Log(title = "视频管理", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TVideoManager tVideoManager)
    {
        return toAjax(tVideoManagerService.updateTVideoManager(tVideoManager));
    }

    /**
     * 删除视频管理
     */
    @PreAuthorize("@ss.hasPermi('device:manager:remove')")
    @Log(title = "视频管理", businessType = BusinessType.DELETE)
	@DeleteMapping("/{videoManagerIds}")
    public AjaxResult remove(@PathVariable String[] videoManagerIds)
    {
        return toAjax(tVideoManagerService.deleteTVideoManagerByIds(videoManagerIds));
    }
}
