import request from '@/utils/request'

// 查询工单基础信息列表
export function listBasicsInfo(query) {
  return request({
    url: '/workOrder/basicsInfo/list',
    method: 'get',
    params: query
  })
}

// 查询工单基础信息详细
export function getBasicsInfo(orderId) {
  return request({
    url: '/workOrder/basicsInfo/' + orderId,
    method: 'get'
  })
}

// 新增工单基础信息
export function addBasicsInfo(data) {
  return request({
    url: '/workOrder/basicsInfo',
    method: 'post',
    data: data
  })
}

// 修改工单基础信息
export function updateBasicsInfo(data) {
  return request({
    url: '/workOrder/basicsInfo',
    method: 'put',
    data: data
  })
}

// 修改工单状态
export function updateOrderStatus(data) {
  return request({
    url: '/workOrder/basicsInfo/editStatus',
    method: 'put',
    data: data
  })
}

// 删除工单基础信息
export function delBasicsInfo(orderId) {
  return request({
    url: '/workOrder/basicsInfo/' + orderId,
    method: 'delete'
  })
}

// 导出工单基础信息
export function exportBasicsInfo(query) {
  return request({
    url: '/workOrder/basicsInfo/export',
    method: 'get',
    params: query
  })
}
