import request from '@/utils/request'

// 查询视频管理列表
export function listManager(query) {
  return request({
    url: '/device/manager/list',
    method: 'get',
    params: query
  })
}

export function videoList(query) {
  return request({
    url: '/device/manager/videoList',
    method: 'get',
    params: query
  })
}

// 查询视频管理详细
export function getManager(videoManagerId) {
  return request({
    url: '/device/manager/' + videoManagerId,
    method: 'get'
  })
}

// 新增视频管理
export function addManager(data) {
  return request({
    url: '/device/manager',
    method: 'post',
    data: data
  })
}

// 修改视频管理
export function updateManager(data) {
  return request({
    url: '/device/manager',
    method: 'put',
    data: data
  })
}

// 删除视频管理
export function delManager(videoManagerId) {
  return request({
    url: '/device/manager/' + videoManagerId,
    method: 'delete'
  })
}

// 导出视频管理
export function exportManager(query) {
  return request({
    url: '/device/manager/export',
    method: 'get',
    params: query
  })
}
