import request from '@/utils/request'

// 查询设备监控列表
export function listDevice(query) {
  return request({
    url: '/system/device/list',
    method: 'get',
    params: query
  })
}

// 查询设备监控详细
export function getDevice(monitorId) {
  return request({
    url: '/system/device/' + monitorId,
    method: 'get'
  })
}

// 新增设备监控
export function addDevice(data) {
  return request({
    url: '/system/device',
    method: 'post',
    data: data
  })
}

export function batchAdd(data) {
  return request({
    url: '/system/device/batchAdd',
    method: 'post',
    data: data
  })
}

// 修改设备监控
export function updateDevice(data) {
  return request({
    url: '/system/device',
    method: 'put',
    data: data
  })
}

// 删除设备监控
export function delDevice(monitorId) {
  return request({
    url: '/system/device/' + monitorId,
    method: 'delete'
  })
}

// 导出设备监控
export function exportDevice(query) {
  return request({
    url: '/system/device/export',
    method: 'get',
    params: query
  })
}
