package com.zehong.system.service;

import java.util.List;

import com.github.pagehelper.PageInfo;
import com.zehong.system.domain.TDeviceReportData;
import com.zehong.system.domain.form.DeviceReportDataForm;
import com.zehong.system.domain.vo.DeviceReportDataVo;

/**
 * 设备监控Service接口
 * 
 * @author zehong
 * @date 2021-08-09
 */
public interface ITDeviceReportDataService 
{
    /**
     * 查询设备监控
     * 
     * @param deviceId 设备ID
     * @return 设备监控
     */
    public DeviceReportDataVo selectTDeviceReportDataByDeviceId(int deviceId) throws Exception;

    /**
     * 地图弹窗获取实时数据
     *
     * @param deviceId 设备ID
     * @return 设备监控
     */
    public TDeviceReportData selectWindowDataByDeviceId(int deviceId) throws Exception;

    /**
     * 查询设备监控列表
     * 
     * @param deviceReportDataForm 设备监控
     * @return 设备监控集合
     */
    public List<DeviceReportDataVo> selectTDeviceReportDataList(DeviceReportDataForm deviceReportDataForm);

    /**
     * 查询设备监控列表
     *
     * @param deviceReportDataForm 设备监控
     * @return 设备监控集合
     */
    public PageInfo<DeviceReportDataVo> selectTDeviceReportDataPage(DeviceReportDataForm deviceReportDataForm);

    /**
     * 查询设备监控实时数据
     *
     * @param deviceReportDataForm 设备监控
     * @return 设备监控集合
     */
    public List<DeviceReportDataVo> selectRealtimeDataList(DeviceReportDataForm deviceReportDataForm);

    /**
     * 查询设备监控实时数据
     *
     * @param deviceReportDataForm 设备监控
     * @return 设备监控
     */
    public PageInfo<DeviceReportDataVo> selectRealtimeDataPage(DeviceReportDataForm deviceReportDataForm);

    /**
     * 新增设备监控
     * 
     * @param tDeviceReportData 设备监控
     * @return 结果
     */
    public int insertTDeviceReportData(TDeviceReportData tDeviceReportData);

    /**
     * 修改设备监控
     * 
     * @param tDeviceReportData 设备监控
     * @return 结果
     */
    public int updateTDeviceReportData(TDeviceReportData tDeviceReportData);

    /**
     * 批量删除设备监控
     * 
     * @param deviceReportDataIds 需要删除的设备监控ID
     * @return 结果
     */
    public int deleteTDeviceReportDataByIds(Long[] deviceReportDataIds);

    /**
     * 删除设备监控信息
     * 
     * @param deviceReportDataId 设备监控ID
     * @return 结果
     */
    public int deleteTDeviceReportDataById(Long deviceReportDataId);
}
