package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.TDeviceReportData;
import com.zehong.system.domain.form.DeviceReportDataForm;
import com.zehong.system.domain.vo.DeviceReportDataVo;

/**
 * 设备监控Mapper接口
 * 
 * @author zehong
 * @date 2021-08-09
 */
public interface TDeviceReportDataMapper 
{
    /**
     * 查询设备监控
     * 
     * @param deviceNum 物联网编号
     * @return 设备监控
     */
    public TDeviceReportData selectTDeviceReportDataByDeviceNum(String deviceNum);

    /**
     * 查询设备监控列表
     * 
     * @param deviceNum 物联网编号
     * @return 设备监控集合
     */
    public List<TDeviceReportData> getTDeviceReportDataList(String deviceNum);

    /**
     * 查询设备监控列表
     *
     * @param tDeviceReportData 设备监控
     * @return 设备监控集合
     */
    public List<TDeviceReportData> getAlarmDeviceReportDataList(TDeviceReportData tDeviceReportData);

    /**
     * 查询设备监控列表
     *
     * @param deviceReportDataForm 设备监控
     * @return 设备监控集合
     */
    public List<DeviceReportDataVo> selectTDeviceReportDataList(DeviceReportDataForm deviceReportDataForm);

    /**
     * 查询设备监控实时数据
     *
     * @param deviceReportDataForm 设备监控
     * @return 设备监控集合
     */
    public List<DeviceReportDataVo> selectRealtimeDataList(DeviceReportDataForm deviceReportDataForm);

    /**
     * 新增设备监控
     * 
     * @param tDeviceReportData 设备监控
     * @return 结果
     */
    public int insertTDeviceReportData(TDeviceReportData tDeviceReportData);

    /**
     * 修改设备监控
     * 
     * @param tDeviceReportData 设备监控
     * @return 结果
     */
    public int updateTDeviceReportData(TDeviceReportData tDeviceReportData);

    /**
     * 删除设备监控
     * 
     * @param deviceReportDataId 设备监控ID
     * @return 结果
     */
    public int deleteTDeviceReportDataById(Long deviceReportDataId);

    /**
     * 批量删除设备监控
     * 
     * @param deviceReportDataIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTDeviceReportDataByIds(Long[] deviceReportDataIds);
}
