package com.zehong.system.domain.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 设备信息对象 t_device_info
 * 
 * @author zehong
 * @date 2021-07-09
 */
public class DeviceInfoVo extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 设备id */
    private Integer deviceId;

    /** 企业id */
    @Excel(name = "企业id")
    private Integer enterpriseId;

    /** 所属管道编号 */
    @Excel(name = "所属管道编号")
    private int pipeId;

    /** 所属管道名称 */
    @Excel(name = "所属管道名称")
    private String pipeName;

    /** 设备名称 */
    @Excel(name = "设备名称")
    private String deviceName;

    /** 设备编号 */
    @Excel(name = "设备编号")
    private String deviceCode;

    /** 所在地址 */
    @Excel(name = "所在地址")
    private String deviceAddr;

    /** 设备型号 */
    @Excel(name = "设备型号")
    private String deviceModel;

    /** 设备类型（1调压阀，2阀门井，3流量计，4压力表） */
    @Excel(name = "设备类型")
    private String deviceType;

    /** 经度 */
    @Excel(name = "经度")
    private BigDecimal longitude;

    /** 纬度 */
    @Excel(name = "纬度")
    private BigDecimal latitude;

    /** 物联网编号 */
    @Excel(name = "物联网编号")
    private String iotNo;

    /** 设备图片路径 */
    @Excel(name = "设备图片路径")
    private String iconUrl;

    /** 联系人 */
    @Excel(name = "联系人")
    private String linkman;

    /** 电话 */
    @Excel(name = "电话")
    private String phone;

    /** 安装时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "安装时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date installationTime;

    /** 最后巡检时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "最后巡检时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date inspectionTime;

    /** 是否删除 */
    @Excel(name = "是否删除")
    private String isDel;

    /** 备注 */
    @Excel(name = "备注")
    private String remarks;

    public void setDeviceId(Integer deviceId)
    {
        this.deviceId = deviceId;
    }

    public Integer getDeviceId()
    {
        return deviceId;
    }
    public void setEnterpriseId(Integer enterpriseId)
    {
        this.enterpriseId = enterpriseId;
    }

    public Integer getEnterpriseId()
    {
        return enterpriseId;
    }

    public int getPipeId() {
        return pipeId;
    }

    public void setPipeId(int pipeId) {
        this.pipeId = pipeId;
    }

    public String getPipeName() {
        return pipeName;
    }

    public void setPipeName(String pipeName) {
        this.pipeName = pipeName;
    }

    public void setDeviceName(String deviceName)
    {
        this.deviceName = deviceName;
    }

    public String getDeviceName() 
    {
        return deviceName;
    }

    public String getDeviceCode() {
        return deviceCode;
    }

    public void setDeviceCode(String deviceCode) {
        this.deviceCode = deviceCode;
    }

    public void setDeviceAddr(String deviceAddr)
    {
        this.deviceAddr = deviceAddr;
    }

    public String getDeviceAddr() 
    {
        return deviceAddr;
    }
    public void setDeviceModel(String deviceModel) 
    {
        this.deviceModel = deviceModel;
    }

    public String getDeviceModel() 
    {
        return deviceModel;
    }
    public void setDeviceType(String deviceType) 
    {
        this.deviceType = deviceType;
    }

    public String getDeviceType() 
    {
        return deviceType;
    }
    public void setLongitude(BigDecimal longitude) 
    {
        this.longitude = longitude;
    }

    public BigDecimal getLongitude() 
    {
        return longitude;
    }
    public void setLatitude(BigDecimal latitude) 
    {
        this.latitude = latitude;
    }

    public BigDecimal getLatitude() 
    {
        return latitude;
    }
    public void setIotNo(String iotNo) 
    {
        this.iotNo = iotNo;
    }

    public String getIotNo() 
    {
        return iotNo;
    }
    public void setIconUrl(String iconUrl) 
    {
        this.iconUrl = iconUrl;
    }

    public String getIconUrl() 
    {
        return iconUrl;
    }
    public void setLinkman(String linkman) 
    {
        this.linkman = linkman;
    }

    public String getLinkman() 
    {
        return linkman;
    }
    public void setPhone(String phone) 
    {
        this.phone = phone;
    }

    public String getPhone() 
    {
        return phone;
    }
    public void setInstallationTime(Date installationTime) 
    {
        this.installationTime = installationTime;
    }

    public Date getInstallationTime() 
    {
        return installationTime;
    }
    public void setInspectionTime(Date inspectionTime) 
    {
        this.inspectionTime = inspectionTime;
    }

    public Date getInspectionTime() 
    {
        return inspectionTime;
    }

    public String getIsDel() {
        return isDel;
    }

    public void setIsDel(String isDel) {
        this.isDel = isDel;
    }

    public void setRemarks(String remarks)
    {
        this.remarks = remarks;
    }

    public String getRemarks() 
    {
        return remarks;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("deviceId", getDeviceId())
            .append("enterpriseId", getEnterpriseId())
            .append("pipeId", getPipeId())
            .append("pipeName", getPipeName())
            .append("deviceName", getDeviceName())
            .append("deviceCode", getDeviceCode())
            .append("deviceAddr", getDeviceAddr())
            .append("deviceModel", getDeviceModel())
            .append("deviceType", getDeviceType())
            .append("longitude", getLongitude())
            .append("latitude", getLatitude())
            .append("iotNo", getIotNo())
            .append("iconUrl", getIconUrl())
            .append("linkman", getLinkman())
            .append("phone", getPhone())
            .append("installationTime", getInstallationTime())
            .append("inspectionTime", getInspectionTime())
            .append("remarks", getRemarks())
            .toString();
    }
}
