package com.zehong.system.domain.form;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.util.Date;

/**
 * 工单基础信息对象 t_work_order
 * 
 * @author zehong
 * @date 2021-07-19
 */
public class TWorkOrderForm extends BaseEntity
{

    /** 工单id */
    private String orderId;

    /** 工单类型（1巡检信息，2隐患信息，3报警信息） */
    private String orderType;

    /** 工单名称 */
    private String orderName;

    /** 工单状态（0未接收，1已接收，2进行中，3已反馈，4已归档） */
    private String orderStatus;

    /** 指定执行人员（巡检员id） */
    private Long appointInspector;

    /** 开始下发时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date startAllotTime;

    /** 结束下发时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date endAllotTime;

    /** 实际接收人员（巡检员id） */
    @Excel(name = "实际接收人员", readConverterExp = "巡检员id")
    private Long actualInspector;

    /** 实际接收时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "实际接收时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date actualTime;

    /** 用户名 */
    private String userName;

    public void setOrderId(String orderId) 
    {
        this.orderId = orderId;
    }

    public String getOrderId() 
    {
        return orderId;
    }

    public void setOrderType(String orderType) 
    {
        this.orderType = orderType;
    }

    public String getOrderType() 
    {
        return orderType;
    }

    public void setOrderName(String orderName)
    {
        this.orderName = orderName;
    }

    public String getOrderName() 
    {
        return orderName;
    }

    public void setOrderStatus(String orderStatus) 
    {
        this.orderStatus = orderStatus;
    }

    public String getOrderStatus() 
    {
        return orderStatus;
    }

    public void setAppointInspector(Long appointInspector)
    {
        this.appointInspector = appointInspector;
    }

    public Long getAppointInspector()
    {
        return appointInspector;
    }

    public Date getStartAllotTime() {
        return startAllotTime;
    }

    public void setStartAllotTime(Date startAllotTime) {
        this.startAllotTime = startAllotTime;
    }

    public Date getEndAllotTime() {
        return endAllotTime;
    }

    public void setEndAllotTime(Date endAllotTime) {
        this.endAllotTime = endAllotTime;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public Long getActualInspector() {
        return actualInspector;
    }

    public void setActualInspector(Long actualInspector) {
        this.actualInspector = actualInspector;
    }

    public Date getActualTime() {
        return actualTime;
    }

    public void setActualTime(Date actualTime) {
        this.actualTime = actualTime;
    }
}
