package com.zehong.system.domain;

import java.math.BigDecimal;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 设备监控对象 t_monitor_device
 * 
 * @author zehong
 * @date 2021-08-05
 */
public class TMonitorDevice extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 设备监控id */
    private Long monitorId;

    /** 设备id */
    @Excel(name = "设备id")
    private Long deviceId;

    /** 设备阈值 */
    @Excel(name = "设备阈值")
    private BigDecimal deviceThreshold;

    /** 关联管道id */
    @Excel(name = "关联管道id")
    private Long relationPipeId;

    /** 关联管道阈值 */
    @Excel(name = "关联管道阈值")
    private BigDecimal relationPipeThreshold;

    /** 关联设备id */
    @Excel(name = "关联设备id")
    private Long relationDeviceId;

    /** 关联设备阈值 */
    @Excel(name = "关联设备阈值")
    private BigDecimal relationDeviceThreshold;

    private String relationPipeName;

    private String deviceName;

    private String relationDeviceName;

    public String getRelationPipeName() {
        return relationPipeName;
    }

    public void setRelationPipeName(String relationPipeName) {
        this.relationPipeName = relationPipeName;
    }

    public String getDeviceName() {
        return deviceName;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    public String getRelationDeviceName() {
        return relationDeviceName;
    }

    public void setRelationDeviceName(String relationDeviceName) {
        this.relationDeviceName = relationDeviceName;
    }

    public void setMonitorId(Long monitorId)
    {
        this.monitorId = monitorId;
    }

    public Long getMonitorId() 
    {
        return monitorId;
    }
    public void setDeviceId(Long deviceId) 
    {
        this.deviceId = deviceId;
    }

    public Long getDeviceId() 
    {
        return deviceId;
    }
    public void setDeviceThreshold(BigDecimal deviceThreshold) 
    {
        this.deviceThreshold = deviceThreshold;
    }

    public BigDecimal getDeviceThreshold() 
    {
        return deviceThreshold;
    }
    public void setRelationPipeId(Long relationPipeId) 
    {
        this.relationPipeId = relationPipeId;
    }

    public Long getRelationPipeId() 
    {
        return relationPipeId;
    }
    public void setRelationPipeThreshold(BigDecimal relationPipeThreshold) 
    {
        this.relationPipeThreshold = relationPipeThreshold;
    }

    public BigDecimal getRelationPipeThreshold() 
    {
        return relationPipeThreshold;
    }
    public void setRelationDeviceId(Long relationDeviceId) 
    {
        this.relationDeviceId = relationDeviceId;
    }

    public Long getRelationDeviceId() 
    {
        return relationDeviceId;
    }
    public void setRelationDeviceThreshold(BigDecimal relationDeviceThreshold) 
    {
        this.relationDeviceThreshold = relationDeviceThreshold;
    }

    public BigDecimal getRelationDeviceThreshold() 
    {
        return relationDeviceThreshold;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("monitorId", getMonitorId())
            .append("deviceId", getDeviceId())
            .append("deviceThreshold", getDeviceThreshold())
            .append("relationPipeId", getRelationPipeId())
            .append("relationPipeThreshold", getRelationPipeThreshold())
            .append("relationDeviceId", getRelationDeviceId())
            .append("relationDeviceThreshold", getRelationDeviceThreshold())
            .append("createTime", getCreateTime())
            .append("updateTime", getUpdateTime())
            .toString();
    }
}
