package com.zehong.system.domain;

import java.math.BigDecimal;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 隐患信息对象 t_hidden_trouble
 * 
 * @author zehong
 * @date 2021-08-20
 */
public class THiddenTrouble extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 隐患信息id */
    private Integer troubleId;

    /** 隐患类型 */
    @Excel(name = "隐患类型")
    private String troubleType;

    /** 隐患名称 */
    @Excel(name = "隐患名称")
    private String troubleName;

    /** 隐患级别 */
    @Excel(name = "隐患级别")
    private String troubleLevel;

    /** 工单id */
    @Excel(name = "工单id")
    private String orderId;

    /** 设备id */
    @Excel(name = "设备id")
    private Integer deviceId;

    /** 设备类型（0管道，1调压阀，2阀门井，3流量计，4压力表） */
    @Excel(name = "设备类型", readConverterExp = "0=管道，1调压阀，2阀门井，3流量计，4压力表")
    private String deviceType;

    /** 经度 */
    @Excel(name = "经度")
    private BigDecimal longitude;

    /** 纬度 */
    @Excel(name = "纬度")
    private BigDecimal latitude;

    /** 是否作废（0正常，1作废） */
    @Excel(name = "是否作废（0正常，1作废）")
    private String isDel;

    /** 处理状态（1不需处理，2已处理完成，3未处理完成） */
    @Excel(name = "处理状态", readConverterExp = "1不需处理，2已处理完成，3未处理完成")
    private String dealStatus;

    /** 地址 */
    @Excel(name = "地址")
    private String address;

    /** 备注 */
    @Excel(name = "备注")
    private String remarks;

    /** 图片地址 */
    @Excel(name = "图片地址")
    private String pictureUrl;

    /** 上报人（用户id） */
    @Excel(name = "上报人", readConverterExp = "用户id")
    private Long reportMan;

    public void setTroubleId(Integer troubleId)
    {
        this.troubleId = troubleId;
    }

    public Integer getTroubleId()
    {
        return troubleId;
    }

    public String getTroubleName() {
        return troubleName;
    }

    public void setTroubleName(String troubleName) {
        this.troubleName = troubleName;
    }

    public void setTroubleType(String troubleType)
    {
        this.troubleType = troubleType;
    }

    public String getTroubleType() 
    {
        return troubleType;
    }
    public void setDeviceId(Integer deviceId)
    {
        this.deviceId = deviceId;
    }

    public Integer getDeviceId()
    {
        return deviceId;
    }
    public void setTroubleLevel(String troubleLevel) 
    {
        this.troubleLevel = troubleLevel;
    }

    public String getTroubleLevel() 
    {
        return troubleLevel;
    }
    public void setOrderId(String orderId) 
    {
        this.orderId = orderId;
    }

    public String getOrderId() 
    {
        return orderId;
    }
    public void setLongitude(BigDecimal longitude) 
    {
        this.longitude = longitude;
    }

    public BigDecimal getLongitude() 
    {
        return longitude;
    }
    public void setDeviceType(String deviceType) 
    {
        this.deviceType = deviceType;
    }

    public String getDeviceType() 
    {
        return deviceType;
    }
    public void setLatitude(BigDecimal latitude) 
    {
        this.latitude = latitude;
    }

    public BigDecimal getLatitude() 
    {
        return latitude;
    }

    public String getIsDel() {
        return isDel;
    }

    public void setIsDel(String isDel) {
        this.isDel = isDel;
    }

    public void setDealStatus(String dealStatus)
    {
        this.dealStatus = dealStatus;
    }

    public String getDealStatus() 
    {
        return dealStatus;
    }
    public void setAddress(String address) 
    {
        this.address = address;
    }

    public String getAddress() 
    {
        return address;
    }
    public void setRemarks(String remarks) 
    {
        this.remarks = remarks;
    }

    public String getRemarks() 
    {
        return remarks;
    }
    public void setPictureUrl(String pictureUrl) 
    {
        this.pictureUrl = pictureUrl;
    }

    public String getPictureUrl() 
    {
        return pictureUrl;
    }
    public void setReportMan(Long reportMan) 
    {
        this.reportMan = reportMan;
    }

    public Long getReportMan() 
    {
        return reportMan;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("troubleId", getTroubleId())
            .append("troubleType", getTroubleType())
            .append("deviceId", getDeviceId())
            .append("troubleLevel", getTroubleLevel())
            .append("orderId", getOrderId())
            .append("longitude", getLongitude())
            .append("deviceType", getDeviceType())
            .append("latitude", getLatitude())
            .append("dealStatus", getDealStatus())
            .append("updateTime", getUpdateTime())
            .append("address", getAddress())
            .append("createTime", getCreateTime())
            .append("remarks", getRemarks())
            .append("pictureUrl", getPictureUrl())
            .append("reportMan", getReportMan())
            .toString();
    }
}
