package com.zehong.web.controller.websocket;

import com.alibaba.fastjson.JSONObject;
import com.zehong.system.domain.vo.DeviceAlarmVo;
import com.zehong.system.service.ITDeviceAlarmService;
import com.zehong.system.service.WebSocketServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("/websocket")
public class WebSocketController {

    private static final Logger log = LoggerFactory.getLogger(WebSocketController.class);

    @Autowired
    private WebSocketServer webSocketServer;

    @Autowired
    private ITDeviceAlarmService itDeviceAlarmService;


    @GetMapping("/send")
    public void send(int alarmId){
        try {
            DeviceAlarmVo alarm = itDeviceAlarmService.selectTDeviceAlarmById(alarmId);
            webSocketServer.batchSendMessage(JSONObject.toJSONString(alarm));
        } catch (Exception e) {
            log.error("wesocket发送失败！");
        }

    }
}
