package com.zehong.system.service.impl;

import java.util.ArrayList;
import java.util.List;
import com.zehong.common.utils.DateUtils;
import com.zehong.system.domain.TDeviceInfo;
import com.zehong.system.domain.TPipe;
import com.zehong.system.domain.vo.DeviceAlarmVo;
import com.zehong.system.mapper.TDeviceInfoMapper;
import com.zehong.system.mapper.TPipeMapper;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TDeviceAlarmMapper;
import com.zehong.system.domain.TDeviceAlarm;
import com.zehong.system.service.ITDeviceAlarmService;

/**
 * 报警信息Service业务层处理
 * 
 * @author zehong
 * @date 2021-07-21
 */
@Service
public class TDeviceAlarmServiceImpl implements ITDeviceAlarmService 
{
    @Autowired
    private TDeviceAlarmMapper tDeviceAlarmMapper;
    @Autowired
    private TDeviceInfoMapper tDeviceInfoMapper;
    @Autowired
    private TPipeMapper tPipeMapper;

    /**
     * 查询报警信息
     * 
     * @param alarmId 报警信息ID
     * @return 报警信息
     */
    @Override
    public DeviceAlarmVo selectTDeviceAlarmById(int alarmId) throws Exception
    {
        DeviceAlarmVo deviceAlarmVo = new DeviceAlarmVo();
        TDeviceAlarm tDeviceAlarm = tDeviceAlarmMapper.selectTDeviceAlarmById(alarmId);

        BeanUtils.copyProperties(tDeviceAlarm, deviceAlarmVo);

        if("0".equals(tDeviceAlarm.getDeviceType())){
            TPipe pipe = tPipeMapper.selectTPipeById(tDeviceAlarm.getDeviceId());
            deviceAlarmVo.setDeviceCode(pipe.getPipeCode());
            deviceAlarmVo.setDeviceName(pipe.getPipeName());
        } else {
            TDeviceInfo deviceInfo = tDeviceInfoMapper.selectTDeviceInfoById(tDeviceAlarm.getDeviceId());
            deviceAlarmVo.setDeviceCode(deviceInfo.getDeviceCode());
            deviceAlarmVo.setDeviceName(deviceInfo.getDeviceName());
            deviceAlarmVo.setIotNo(deviceInfo.getIotNo());
        }

        return deviceAlarmVo;
    }

    /**
     * 查询报警信息列表
     * 
     * @param tDeviceAlarm 报警信息
     * @return 报警信息
     */
    @Override
    public List<DeviceAlarmVo> selectTDeviceAlarmList(TDeviceAlarm tDeviceAlarm) throws Exception
    {
        List<DeviceAlarmVo> list = new ArrayList<>();
        List<TDeviceAlarm> deviceAlarmList = tDeviceAlarmMapper.selectTDeviceAlarmList(tDeviceAlarm);

        for(TDeviceAlarm alarm : deviceAlarmList){
            DeviceAlarmVo deviceAlarmVo = new DeviceAlarmVo();
            BeanUtils.copyProperties(alarm, deviceAlarmVo);

            if("0".equals(tDeviceAlarm.getDeviceType())){
                TPipe pipe = tPipeMapper.selectTPipeById(alarm.getDeviceId());
                deviceAlarmVo.setDeviceCode(pipe.getPipeCode());
                deviceAlarmVo.setDeviceName(pipe.getPipeName());
            } else {
                TDeviceInfo deviceInfo = tDeviceInfoMapper.selectTDeviceInfoById(alarm.getDeviceId());
                deviceAlarmVo.setDeviceCode(deviceInfo.getDeviceCode());
                deviceAlarmVo.setDeviceName(deviceInfo.getDeviceName());
            }

            list.add(deviceAlarmVo);
        }
        return list;
    }

    /**
     * 新增报警信息
     * 
     * @param tDeviceAlarm 报警信息
     * @return 结果
     */
    @Override
    public int insertTDeviceAlarm(TDeviceAlarm tDeviceAlarm)
    {
        tDeviceAlarm.setCreateTime(DateUtils.getNowDate());
        return tDeviceAlarmMapper.insertTDeviceAlarm(tDeviceAlarm);
    }

    /**
     * 修改报警信息
     * 
     * @param tDeviceAlarm 报警信息
     * @return 结果
     */
    @Override
    public int updateTDeviceAlarm(TDeviceAlarm tDeviceAlarm)
    {
        tDeviceAlarm.setUpdateTime(DateUtils.getNowDate());
        return tDeviceAlarmMapper.updateTDeviceAlarm(tDeviceAlarm);
    }

    /**
     * 批量删除报警信息
     * 
     * @param alarmIds 需要删除的报警信息ID
     * @return 结果
     */
    @Override
    public int deleteTDeviceAlarmByIds(int[] alarmIds)
    {
        return tDeviceAlarmMapper.deleteTDeviceAlarmByIds(alarmIds);
    }

    /**
     * 删除报警信息信息
     * 
     * @param alarmId 报警信息ID
     * @return 结果
     */
    @Override
    public int deleteTDeviceAlarmById(int alarmId)
    {
        return tDeviceAlarmMapper.deleteTDeviceAlarmById(alarmId);
    }
}
