package com.zehong.system.domain.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.zehong.common.core.domain.BaseEntity;
import com.zehong.system.domain.TDeviceInfo;
import com.zehong.system.domain.TInspectionData;
import com.zehong.system.domain.TPipe;

import java.util.Date;
import java.util.List;

/**
 * 巡检计划对象 t_inspection_plan
 * 
 * @author zehong
 * @date 2021-07-21
 */
public class InspectionPlanVo extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 巡检计划id */
    private Integer planId;

    /** 巡检计划名称 */
    private String planName;

    /** 设备id */
    private String deviceIds;

    /** 设备列表 */
    private List<TInspectionData> inspectionDataList;

    /** 设备列表 */
    private List<TDeviceInfo> deviceList;

    /** 管道列表 */
    private List<TPipe> pipeList;

    /** 工单id */
    private String orderId;

    /** 开始时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date startTime;

    /** 结束时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date endTime;

    /** 地址 */
    private String address;

    /** 计划状态（0未下发，1已下发，2进行中，3已完成） */
    private String planStatus;

    /** 是否作废（0正常，1作废） */
    private String isDel;

    /** 计划描述 */
    private String remarks;

    public void setPlanId(Integer planId)
    {
        this.planId = planId;
    }

    public Integer getPlanId()
    {
        return planId;
    }

    public void setPlanName(String planName) 
    {
        this.planName = planName;
    }

    public String getPlanName() 
    {
        return planName;
    }

    public String getDeviceIds() {
        return deviceIds;
    }

    public void setDeviceIds(String deviceIds) {
        this.deviceIds = deviceIds;
    }

    public List<TInspectionData> getInspectionDataList() {
        return inspectionDataList;
    }

    public void setInspectionDataList(List<TInspectionData> inspectionDataList) {
        this.inspectionDataList = inspectionDataList;
    }

    public  List<TDeviceInfo> getDeviceList() {
        return deviceList;
    }

    public void setDeviceList( List<TDeviceInfo> deviceList) {
        this.deviceList = deviceList;
    }

    public List<TPipe> getPipeList() {
        return pipeList;
    }

    public void setPipeList(List<TPipe> pipeList) {
        this.pipeList = pipeList;
    }

    public void setOrderId(String orderId)
    {
        this.orderId = orderId;
    }

    public String getOrderId() 
    {
        return orderId;
    }

    public void setStartTime(Date startTime)
    {
        this.startTime = startTime;
    }

    public Date getStartTime() 
    {
        return startTime;
    }

    public void setEndTime(Date endTime) 
    {
        this.endTime = endTime;
    }

    public Date getEndTime() 
    {
        return endTime;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setPlanStatus(String planStatus)
    {
        this.planStatus = planStatus;
    }

    public String getPlanStatus() 
    {
        return planStatus;
    }

    public String getIsDel() {
        return isDel;
    }

    public void setIsDel(String isDel) {
        this.isDel = isDel;
    }

    public void setRemarks(String remarks)
    {
        this.remarks = remarks;
    }

    public String getRemarks() 
    {
        return remarks;
    }

}
