package com.zehong.web.controller.dataMonitoring;

import java.util.List;

import com.zehong.system.domain.vo.DeviceAlarmVo;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TDeviceAlarm;
import com.zehong.system.service.ITDeviceAlarmService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 报警信息Controller
 * 
 * @author zehong
 * @date 2021-07-21
 */
@RestController
@RequestMapping("/dataMonitoring/deviceAlarm")
public class TDeviceAlarmController extends BaseController
{
    @Autowired
    private ITDeviceAlarmService tDeviceAlarmService;

    /**
     * 查询报警信息列表
     */
    @PreAuthorize("@ss.hasPermi('dataMonitoring:deviceAlarm:list')")
    @GetMapping("/list")
    public TableDataInfo list(TDeviceAlarm tDeviceAlarm) throws Exception
    {
        startPage();
        List<DeviceAlarmVo> list = null;
        try {
            list = tDeviceAlarmService.selectTDeviceAlarmList(tDeviceAlarm);
        } catch (Exception e) {
            e.printStackTrace();
            throw new Exception("查询报警信息列表出错");
        }
        return getDataTable(list);
    }

    /**
     * 获取报警信息详细信息
     */
    @PreAuthorize("@ss.hasPermi('dataMonitoring:deviceAlarm:query')")
    @GetMapping(value = "/{alarmId}")
    public AjaxResult getInfo(@PathVariable("alarmId") int alarmId) throws Exception
    {
        DeviceAlarmVo deviceAlarmVo = null;
        try {
            deviceAlarmVo = tDeviceAlarmService.selectTDeviceAlarmById(alarmId);
        } catch (Exception e) {
            e.printStackTrace();
            throw new Exception("获取报警信息详细信息出错");
        }
        return AjaxResult.success(deviceAlarmVo);
    }

    /**
     * 新增报警信息
     */
    @PreAuthorize("@ss.hasPermi('dataMonitoring:deviceAlarm:add')")
    @Log(title = "报警信息", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TDeviceAlarm tDeviceAlarm)
    {
        return toAjax(tDeviceAlarmService.insertTDeviceAlarm(tDeviceAlarm));
    }

    /**
     * 修改报警信息
     */
    @PreAuthorize("@ss.hasPermi('dataMonitoring:deviceAlarm:edit')")
    @Log(title = "报警信息", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TDeviceAlarm tDeviceAlarm)
    {
        return toAjax(tDeviceAlarmService.updateTDeviceAlarm(tDeviceAlarm));
    }

    /**
     * 删除报警信息
     */
    @PreAuthorize("@ss.hasPermi('dataMonitoring:deviceAlarm:remove')")
    @Log(title = "报警信息", businessType = BusinessType.DELETE)
	@DeleteMapping("/{alarmIds}")
    public AjaxResult remove(@PathVariable int[] alarmIds)
    {
        return toAjax(tDeviceAlarmService.deleteTDeviceAlarmByIds(alarmIds));
    }
}
