package com.zehong.web.controller.workOrder;

import java.util.List;

import com.zehong.common.utils.StringUtils;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TOrderFeedback;
import com.zehong.system.service.ITOrderFeedbackService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 工单反馈信息Controller
 * 
 * @author zehong
 * @date 2021-07-19
 */
@RestController
@RequestMapping("/workOrder/feedback")
public class TOrderFeedbackController extends BaseController
{
    @Autowired
    private ITOrderFeedbackService tOrderFeedbackService;

    /**
     * 查询工单反馈信息列表
     */
    @PreAuthorize("@ss.hasPermi('workOrder:feedback:list')")
    @GetMapping("/list")
    public TableDataInfo list(TOrderFeedback tOrderFeedback)
    {
        startPage();
        List<TOrderFeedback> list = tOrderFeedbackService.selectTOrderFeedbackList(tOrderFeedback);
        return getDataTable(list);
    }

    /**
     * 导出工单反馈信息列表
     */
    @PreAuthorize("@ss.hasPermi('workOrder:feedback:export')")
    @Log(title = "工单反馈信息", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TOrderFeedback tOrderFeedback)
    {
        List<TOrderFeedback> list = tOrderFeedbackService.selectTOrderFeedbackList(tOrderFeedback);
        ExcelUtil<TOrderFeedback> util = new ExcelUtil<TOrderFeedback>(TOrderFeedback.class);
        return util.exportExcel(list, "工单反馈信息数据");
    }

    /**
     * 获取工单反馈信息详细信息
     */
    @PreAuthorize("@ss.hasPermi('workOrder:feedback:query')")
    @GetMapping(value = "/{feedbackId}")
    public AjaxResult getInfo(@PathVariable("feedbackId") int feedbackId)
    {
        return AjaxResult.success(tOrderFeedbackService.selectTOrderFeedbackById(feedbackId));
    }

    /**
     * 新增工单反馈信息
     */
    @PreAuthorize("@ss.hasPermi('workOrder:feedback:add')")
    @Log(title = "工单反馈信息", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TOrderFeedback tOrderFeedback) throws Exception
    {
        int result = 0;
        try {
            result = tOrderFeedbackService.insertTOrderFeedback(tOrderFeedback);
        } catch (Exception e) {
            e.printStackTrace();
            throw new Exception(StringUtils.format("工单反馈操作失败，数据有误"));
        }
        return toAjax(result);
    }

    /**
     * 修改工单反馈信息
     */
    @PreAuthorize("@ss.hasPermi('workOrder:feedback:edit')")
    @Log(title = "工单反馈信息", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TOrderFeedback tOrderFeedback)
    {
        return toAjax(tOrderFeedbackService.updateTOrderFeedback(tOrderFeedback));
    }

    /**
     * 删除工单反馈信息
     */
    @PreAuthorize("@ss.hasPermi('workOrder:feedback:remove')")
    @Log(title = "工单反馈信息", businessType = BusinessType.DELETE)
	@DeleteMapping("/{feedbackIds}")
    public AjaxResult remove(@PathVariable int[] feedbackIds)
    {
        return toAjax(tOrderFeedbackService.deleteTOrderFeedbackByIds(feedbackIds));
    }
}
