package com.zehong.system.service.impl;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import com.zehong.common.utils.DateUtils;
import com.zehong.system.domain.TInspectionData;
import com.zehong.system.domain.form.InspectionPlanForm;
import com.zehong.system.domain.vo.InspectionPlanVo;
import com.zehong.system.mapper.TInspectionDataMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TInspectionPlanMapper;
import com.zehong.system.domain.TInspectionPlan;
import com.zehong.system.service.ITInspectionPlanService;

/**
 * 巡检计划Service业务层处理
 * 
 * @author zehong
 * @date 2021-07-21
 */
@Service
public class TInspectionPlanServiceImpl implements ITInspectionPlanService 
{
    @Autowired
    private TInspectionPlanMapper tInspectionPlanMapper;
    @Autowired
    private TInspectionDataMapper tInspectionDataMapper;

    /**
     * 查询巡检计划
     * 
     * @param planId 巡检计划ID
     * @return 巡检计划
     */
    @Override
    public TInspectionPlan selectTInspectionPlanById(int planId) throws Exception
    {
        return tInspectionPlanMapper.selectTInspectionPlanById(planId);
    }

    /**
     * 查询巡检计划列表
     * 
     * @param inspectionPlanForm 巡检计划
     * @return 巡检计划
     */
    @Override
    public List<TInspectionPlan> selectTInspectionPlanList(InspectionPlanForm inspectionPlanForm)
    {
        return tInspectionPlanMapper.selectTInspectionPlanList(inspectionPlanForm);
    }

    /**
     * 新增巡检计划
     * 
     * @param tInspectionPlan 巡检计划
     * @return 结果
     */
    @Override
    public int insertTInspectionPlan(TInspectionPlan tInspectionPlan) throws Exception
    {
        String deviceIds = tInspectionPlan.getDeviceIds();
        String[] stringArr = deviceIds.split("],");
        String deviceType = null;

        for(int i = 0; i < stringArr.length; i++) {
            String[] temp = stringArr[i].split(",");

            for (int j = 0; j < temp.length; j++) {
                String regEx="[^0-9]";
                Pattern p = Pattern.compile(regEx);
                Matcher m = p.matcher(temp[j]);
//                System.out.println(m.replaceAll("").trim());

                if(j == 0) {
                    deviceType = m.replaceAll("").trim();
                } else {
                    Integer deviceId = Integer.valueOf(m.replaceAll("").trim());
                    TInspectionData data = new TInspectionData();
                    data.setPlanId(tInspectionPlan.getPlanId());
                    data.setDeviceId(deviceId);
                    data.setDeviceType(deviceType);
                    data.setCreateTime(DateUtils.getNowDate());

                    tInspectionDataMapper.insertTInspectionData(data);
                }
            }
        }
        tInspectionPlan.setPlanStatus("0");
        tInspectionPlan.setCreateTime(DateUtils.getNowDate());
        return tInspectionPlanMapper.insertTInspectionPlan(tInspectionPlan);
    }

    /**
     * 修改巡检计划
     *
     * @param tInspectionPlan 巡检计划
     * @return 结果
     */
    @Override
    public int updateTInspectionPlan(TInspectionPlan tInspectionPlan) throws Exception
    {
        tInspectionDataMapper.deleteTInspectionDataByPlanId(tInspectionPlan.getPlanId());

        String deviceIds = tInspectionPlan.getDeviceIds();
        String[] stringArr = deviceIds.split("],");
        String deviceType = null;

        for(int i = 0; i < stringArr.length; i++) {
            String[] temp = stringArr[i].split(",");

            for (int j = 0; j < temp.length; j++) {
                String regEx="[^0-9]";
                Pattern p = Pattern.compile(regEx);
                Matcher m = p.matcher(temp[j]);
//                System.out.println(m.replaceAll("").trim());

                if(j == 0) {
                    deviceType = m.replaceAll("").trim();
                } else {
                    Integer deviceId = Integer.valueOf(m.replaceAll("").trim());
                    TInspectionData data = new TInspectionData();
                    data.setPlanId(tInspectionPlan.getPlanId());
                    data.setDeviceId(deviceId);
                    data.setDeviceType(deviceType);
                    data.setCreateTime(DateUtils.getNowDate());

                    tInspectionDataMapper.insertTInspectionData(data);
                }
            }
        }

        tInspectionPlan.setUpdateTime(DateUtils.getNowDate());
        return tInspectionPlanMapper.updateTInspectionPlan(tInspectionPlan);
    }

    /**
     * 批量删除巡检计划
     * 
     * @param planIds 需要删除的巡检计划ID
     * @return 结果
     */
    @Override
    public int deleteTInspectionPlanByIds(int[] planIds)
    {
        return tInspectionPlanMapper.deleteTInspectionPlanByIds(planIds);
    }

    /**
     * 删除巡检计划信息
     * 
     * @param planId 巡检计划ID
     * @return 结果
     */
    @Override
    public int deleteTInspectionPlanById(int planId)
    {
        return tInspectionPlanMapper.deleteTInspectionPlanById(planId);
    }
}
