package com.zehong.system.service;

import java.util.List;
import java.util.Map;

import com.zehong.system.domain.TUserLocation;

/**
 * 巡检员定位Service接口
 * 
 * @author zehong
 * @date 2021-07-31
 */
public interface ITUserLocationService 
{
    /**
     * 查询巡检员定位
     * 
     * @param locationId 巡检员定位ID
     * @return 巡检员定位
     */
    public TUserLocation selectTUserLocationById(Long locationId);

    /**
     * 查询巡检员定位列表
     * 
     * @param tUserLocation 巡检员定位
     * @return 巡检员定位集合
     */
    public List<TUserLocation> selectTUserLocationList(TUserLocation tUserLocation);

    /**
     * 查询巡检员定位列表ByMap
     * @param map
     * @return
     */
    List<TUserLocation> selectTUserLocationListByMap(Map<String,Object> map);

    /**
     * 新增巡检员定位
     * 
     * @param tUserLocation 巡检员定位
     * @return 结果
     */
    public int insertTUserLocation(TUserLocation tUserLocation);

    /**
     * 修改巡检员定位
     * 
     * @param tUserLocation 巡检员定位
     * @return 结果
     */
    public int updateTUserLocation(TUserLocation tUserLocation);

    /**
     * 批量删除巡检员定位
     * 
     * @param locationIds 需要删除的巡检员定位ID
     * @return 结果
     */
    public int deleteTUserLocationByIds(Long[] locationIds);

    /**
     * 删除巡检员定位信息
     * 
     * @param locationId 巡检员定位ID
     * @return 结果
     */
    public int deleteTUserLocationById(Long locationId);
}
