package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.TWorkOrder;
import com.zehong.system.domain.form.TWorkOrderForm;

/**
 * 工单基础信息Mapper接口
 * 
 * @author zehong
 * @date 2021-07-19
 */
public interface TWorkOrderMapper 
{
    /**
     * 获取工单基础信息id
     *
     * @return 工单基础信息id
     */
    public String getWorkOrderId();

    /**
     * 查询工单基础信息
     * 
     * @param orderId 工单基础信息ID
     * @return 工单基础信息
     */
    public TWorkOrder selectTWorkOrderById(String orderId);

    /**
     * 查询工单基础信息列表
     * 
     * @param tWorkOrder 工单基础信息
     * @return 工单基础信息集合
     */
    public List<TWorkOrder> selectTWorkOrderList(TWorkOrderForm tWorkOrderForm);

    /**
     * 新增工单基础信息
     * 
     * @param tWorkOrder 工单基础信息
     * @return 结果
     */
    public int insertTWorkOrder(TWorkOrder tWorkOrder);

    /**
     * 修改工单基础信息
     * 
     * @param tWorkOrder 工单基础信息
     * @return 结果
     */
    public int updateTWorkOrder(TWorkOrder tWorkOrder);

    /**
     * 删除工单基础信息
     * 
     * @param orderId 工单基础信息ID
     * @return 结果
     */
    public int deleteTWorkOrderById(String orderId);

    /**
     * 批量删除工单基础信息
     * 
     * @param orderIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTWorkOrderByIds(String[] orderIds);
}
