package com.zehong.system.mapper;

import com.zehong.system.domain.TUserLocation;

import java.util.List;
import java.util.Map;

/**
 * 巡检员定位Mapper接口
 * 
 * @author zehong
 * @date 2021-07-31
 */
public interface TUserLocationMapper 
{
    /**
     * 查询巡检员定位
     * 
     * @param locationId 巡检员定位ID
     * @return 巡检员定位
     */
    public TUserLocation selectTUserLocationById(Long locationId);

    /**
     * 查询巡检员定位列表
     * 
     * @param tUserLocation 巡检员定位
     * @return 巡检员定位集合
     */
    public List<TUserLocation> selectTUserLocationList(TUserLocation tUserLocation);

    /**
     * 查询巡检员定位byMap
     * @param map
     * @return
     */
    List<TUserLocation> selectTUserLocationListByMap(Map<String,Object> map);

    /**
     * 新增巡检员定位
     * 
     * @param tUserLocation 巡检员定位
     * @return 结果
     */
    public int insertTUserLocation(TUserLocation tUserLocation);

    /**
     * 修改巡检员定位
     * 
     * @param tUserLocation 巡检员定位
     * @return 结果
     */
    public int updateTUserLocation(TUserLocation tUserLocation);

    /**
     * 删除巡检员定位
     * 
     * @param locationId 巡检员定位ID
     * @return 结果
     */
    public int deleteTUserLocationById(Long locationId);

    /**
     * 批量删除巡检员定位
     * 
     * @param locationIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTUserLocationByIds(Long[] locationIds);
}
