package com.zehong.system.domain;

import java.math.BigDecimal;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 隐患信息对象 t_hidden_trouble
 * 
 * @author zehong
 * @date 2021-07-21
 */
public class THiddenTrouble extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 隐患信息id */
    private Integer troubleId;

    /** 设备id */
    @Excel(name = "设备id")
    private Integer deviceId;

    /** 设备类型（0管道，1调压阀，2阀门井，3流量计，4压力表） */
    private String deviceType;

    /** 工单id */
    @Excel(name = "工单id")
    private String orderId;

    /** 地址 */
    @Excel(name = "地址")
    private String address;

    /** 经度 */
    @Excel(name = "经度")
    private BigDecimal longitude;

    /** 纬度 */
    @Excel(name = "纬度")
    private BigDecimal latitude;

    /** 坐标 */
    @Excel(name = "坐标")
    private String coordinates;

    /** 处理状态（1不需处理，2已处理完成，3未处理完成） */
    @Excel(name = "处理状态", readConverterExp = "1不需处理，2已处理完成，3未处理完成")
    private String dealStatus;

    /** 备注 */
    @Excel(name = "备注")
    private String remarks;

    public void setTroubleId(Integer troubleId)
    {
        this.troubleId = troubleId;
    }

    public Integer getTroubleId()
    {
        return troubleId;
    }
    public void setDeviceId(Integer deviceId)
    {
        this.deviceId = deviceId;
    }

    public Integer getDeviceId()
    {
        return deviceId;
    }

    public String getDeviceType() {
        return deviceType;
    }

    public void setDeviceType(String deviceType) {
        this.deviceType = deviceType;
    }

    public void setOrderId(String orderId)
    {
        this.orderId = orderId;
    }

    public String getOrderId() 
    {
        return orderId;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setLongitude(BigDecimal longitude)
    {
        this.longitude = longitude;
    }

    public BigDecimal getLongitude() 
    {
        return longitude;
    }
    public void setLatitude(BigDecimal latitude) 
    {
        this.latitude = latitude;
    }

    public BigDecimal getLatitude() 
    {
        return latitude;
    }

    public String getCoordinates() {
        return coordinates;
    }

    public void setCoordinates(String coordinates) {
        this.coordinates = coordinates;
    }

    public void setDealStatus(String dealStatus)
    {
        this.dealStatus = dealStatus;
    }

    public String getDealStatus() 
    {
        return dealStatus;
    }
    public void setRemarks(String remarks) 
    {
        this.remarks = remarks;
    }

    public String getRemarks() 
    {
        return remarks;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("troubleId", getTroubleId())
            .append("deviceId", getDeviceId())
            .append("deviceType", getDeviceType())
            .append("orderId", getOrderId())
            .append("address", getAddress())
            .append("longitude", getLongitude())
            .append("latitude", getLatitude())
            .append("coordinates", getCoordinates())
            .append("dealStatus", getDealStatus())
            .append("updateTime", getUpdateTime())
            .append("createTime", getCreateTime())
            .append("remarks", getRemarks())
            .toString();
    }
}
