package com.zehong.web.controller.websocket;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zehong.system.domain.TDeviceAlarm;
import com.zehong.system.service.ITDeviceAlarmService;
import com.zehong.system.service.ITDeviceInfoService;
import com.zehong.system.service.ITPipeService;
import com.zehong.system.service.WebSocketServer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@RestController
@RequestMapping("/websocket")
public class WebSocketController {

    @Autowired
    private WebSocketServer webSocketServer;

    @Autowired
    private ITDeviceAlarmService itDeviceAlarmService;

    @Autowired
    private ITDeviceInfoService itDeviceInfoService;

    @Autowired
    private ITPipeService itPipeService;

    private final static String PIPE_TYPE = "0";

    @GetMapping("/send")
    public void send(int alarmId){
        TDeviceAlarm alarm = itDeviceAlarmService.selectTDeviceAlarmById(alarmId);
        JSONObject json = new JSONObject();
        json.put("alarmInfo",alarm);
        if(PIPE_TYPE.equals(alarm.getAlarmType())){
            json.put("deviceInfo",itPipeService.selectTPipeById(alarm.getDeviceId()));
        }else{
            json.put("deviceInfo",itDeviceInfoService.selectTDeviceInfoById(alarm.getDeviceId()));
        }
        webSocketServer.batchSendMessage(alarm.toString());
    }
}
