package com.zehong.system.service.impl;

import java.util.ArrayList;
import java.util.List;

import com.zehong.common.core.domain.entity.SysUser;
import com.zehong.common.utils.DateUtils;
import com.zehong.common.utils.ExceptionUtil;
import com.zehong.common.utils.StringUtils;
import com.zehong.system.domain.vo.WorkOrderVo;
import com.zehong.system.mapper.SysUserMapper;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TWorkOrderMapper;
import com.zehong.system.domain.TWorkOrder;
import com.zehong.system.service.ITWorkOrderService;

/**
 * 工单基础信息Service业务层处理
 * 
 * @author zehong
 * @date 2021-07-19
 */
@Service
public class TWorkOrderServiceImpl implements ITWorkOrderService 
{
    @Autowired
    private TWorkOrderMapper tWorkOrderMapper;
    @Autowired
    private SysUserMapper sysUserMapper;

    /**
     * 获取工单基础信息id
     *
     * @return 工单基础信息id
     */
    @Override
    public String getWorkOrderId()
    {
        return tWorkOrderMapper.getWorkOrderId();
    }

    /**
     * 查询工单基础信息
     * 
     * @param orderId 工单基础信息ID
     * @return 工单基础信息
     */
    @Override
    public WorkOrderVo selectTWorkOrderById(String orderId)
    {
        WorkOrderVo workOrderVo = new WorkOrderVo();
        TWorkOrder tWorkOrder = tWorkOrderMapper.selectTWorkOrderById(orderId);

        BeanUtils.copyProperties(tWorkOrder, workOrderVo);

        // 获取巡检员姓名
        SysUser appointInspector = sysUserMapper.selectUserById(tWorkOrder.getAppointInspector());
        workOrderVo.setAppointInspectorName(appointInspector.getNickName());

        if(tWorkOrder.getActualInspector() != tWorkOrder.getAppointInspector() && tWorkOrder.getActualInspector() != null){
            SysUser actualInspector = sysUserMapper.selectUserById(tWorkOrder.getActualInspector());
            workOrderVo.setActualInspectorName(actualInspector.getNickName());
        } else {
            workOrderVo.setActualInspectorName(appointInspector.getNickName());
        }

        // 获取源数据(1巡检信息，2隐患信息，3报警信息)
        String orderType = tWorkOrder.getOrderType();
        if("1".equals(orderType)){

        } else if("2".equals(orderType)) {

        } else {

        }

        return workOrderVo;
    }

    /**
     * 查询工单基础信息列表
     * 
     * @param tWorkOrder 工单基础信息
     * @return 工单基础信息
     */
    @Override
    public List<WorkOrderVo> selectTWorkOrderList(TWorkOrder tWorkOrder)
    {
        List<WorkOrderVo> workOrderVoList = new ArrayList<WorkOrderVo>();
        List<TWorkOrder> workOrderList = tWorkOrderMapper.selectTWorkOrderList(tWorkOrder);

        if(workOrderList.size() != 0){

            for(TWorkOrder workOrder : workOrderList){
                WorkOrderVo workOrderVo = new WorkOrderVo();
                BeanUtils.copyProperties(workOrder, workOrderVo);

                // 获取巡检员姓名
                SysUser appointInspector = sysUserMapper.selectUserById(workOrder.getAppointInspector());
                workOrderVo.setAppointInspectorName(appointInspector.getNickName());

                if(workOrder.getActualInspector() != workOrder.getAppointInspector() && workOrder.getActualInspector() != null){
                    SysUser actualInspector = sysUserMapper.selectUserById(tWorkOrder.getActualInspector());
                    workOrderVo.setActualInspectorName(actualInspector.getNickName());
                } else {
                    workOrderVo.setActualInspectorName(appointInspector.getNickName());
                }

                workOrderVoList.add(workOrderVo);
            }
        }
        return workOrderVoList;
    }

    /**
     * 新增工单基础信息
     * 
     * @param tWorkOrder 工单基础信息
     * @return 结果
     */
    @Override
    public int insertTWorkOrder(TWorkOrder tWorkOrder)
    {
        String orderId = tWorkOrderMapper.getWorkOrderId();

        tWorkOrder.setOrderId(orderId);
        tWorkOrder.setCreateTime(DateUtils.getNowDate());
        return tWorkOrderMapper.insertTWorkOrder(tWorkOrder);
    }

    /**
     * 修改工单基础信息
     * 
     * @param tWorkOrder 工单基础信息
     * @return 结果
     */
    @Override
    public int updateTWorkOrder(TWorkOrder tWorkOrder)
    {
        return tWorkOrderMapper.updateTWorkOrder(tWorkOrder);
    }

    /**
     * 批量删除工单基础信息
     * 
     * @param orderIds 需要删除的工单基础信息ID
     * @return 结果
     */
    @Override
    public int deleteTWorkOrderByIds(String[] orderIds)
    {
        return tWorkOrderMapper.deleteTWorkOrderByIds(orderIds);
    }

    /**
     * 删除工单基础信息信息
     * 
     * @param orderId 工单基础信息ID
     * @return 结果
     */
    @Override
    public int deleteTWorkOrderById(String orderId)
    {
        return tWorkOrderMapper.deleteTWorkOrderById(orderId);
    }
}
